/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Cvss;
import software.amazon.awssdk.services.securityhub.model.CvssListCopier;
import software.amazon.awssdk.services.securityhub.model.SoftwarePackage;
import software.amazon.awssdk.services.securityhub.model.SoftwarePackageListCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityFixAvailable;
import software.amazon.awssdk.services.securityhub.model.VulnerabilityVendor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Vulnerability
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Vulnerability> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Vulnerability.getter(Vulnerability::id)).setter(Vulnerability.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<List<SoftwarePackage>> VULNERABLE_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VulnerablePackages").getter(Vulnerability.getter(Vulnerability::vulnerablePackages)).setter(Vulnerability.setter(Builder::vulnerablePackages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VulnerablePackages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SoftwarePackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Cvss>> CVSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cvss").getter(Vulnerability.getter(Vulnerability::cvss)).setter(Vulnerability.setter(Builder::cvss)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cvss").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cvss::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedVulnerabilities").getter(Vulnerability.getter(Vulnerability::relatedVulnerabilities)).setter(Vulnerability.setter(Builder::relatedVulnerabilities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedVulnerabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VulnerabilityVendor> VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vendor").getter(Vulnerability.getter(Vulnerability::vendor)).setter(Vulnerability.setter(Builder::vendor)).constructor(VulnerabilityVendor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()}).build();
    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReferenceUrls").getter(Vulnerability.getter(Vulnerability::referenceUrls)).setter(Vulnerability.setter(Builder::referenceUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceUrls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIX_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixAvailable").getter(Vulnerability.getter(Vulnerability::fixAvailableAsString)).setter(Vulnerability.setter(Builder::fixAvailable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixAvailable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VULNERABLE_PACKAGES_FIELD, CVSS_FIELD, RELATED_VULNERABILITIES_FIELD, VENDOR_FIELD, REFERENCE_URLS_FIELD, FIX_AVAILABLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<SoftwarePackage> vulnerablePackages;
    private final List<Cvss> cvss;
    private final List<String> relatedVulnerabilities;
    private final VulnerabilityVendor vendor;
    private final List<String> referenceUrls;
    private final String fixAvailable;

    private Vulnerability(BuilderImpl builder) {
        this.id = builder.id;
        this.vulnerablePackages = builder.vulnerablePackages;
        this.cvss = builder.cvss;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.vendor = builder.vendor;
        this.referenceUrls = builder.referenceUrls;
        this.fixAvailable = builder.fixAvailable;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasVulnerablePackages() {
        return this.vulnerablePackages != null && !(this.vulnerablePackages instanceof SdkAutoConstructList);
    }

    public final List<SoftwarePackage> vulnerablePackages() {
        return this.vulnerablePackages;
    }

    public final boolean hasCvss() {
        return this.cvss != null && !(this.cvss instanceof SdkAutoConstructList);
    }

    public final List<Cvss> cvss() {
        return this.cvss;
    }

    public final boolean hasRelatedVulnerabilities() {
        return this.relatedVulnerabilities != null && !(this.relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    public final List<String> relatedVulnerabilities() {
        return this.relatedVulnerabilities;
    }

    public final VulnerabilityVendor vendor() {
        return this.vendor;
    }

    public final boolean hasReferenceUrls() {
        return this.referenceUrls != null && !(this.referenceUrls instanceof SdkAutoConstructList);
    }

    public final List<String> referenceUrls() {
        return this.referenceUrls;
    }

    public final VulnerabilityFixAvailable fixAvailable() {
        return VulnerabilityFixAvailable.fromValue(this.fixAvailable);
    }

    public final String fixAvailableAsString() {
        return this.fixAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVulnerablePackages() ? this.vulnerablePackages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCvss() ? this.cvss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vendor());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferenceUrls() ? this.referenceUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fixAvailableAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability)obj;
        return Objects.equals(this.id(), other.id()) && this.hasVulnerablePackages() == other.hasVulnerablePackages() && Objects.equals(this.vulnerablePackages(), other.vulnerablePackages()) && this.hasCvss() == other.hasCvss() && Objects.equals(this.cvss(), other.cvss()) && this.hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities() && Objects.equals(this.relatedVulnerabilities(), other.relatedVulnerabilities()) && Objects.equals(this.vendor(), other.vendor()) && this.hasReferenceUrls() == other.hasReferenceUrls() && Objects.equals(this.referenceUrls(), other.referenceUrls()) && Objects.equals(this.fixAvailableAsString(), other.fixAvailableAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Vulnerability").add("Id", (Object)this.id()).add("VulnerablePackages", this.hasVulnerablePackages() ? this.vulnerablePackages() : null).add("Cvss", this.hasCvss() ? this.cvss() : null).add("RelatedVulnerabilities", this.hasRelatedVulnerabilities() ? this.relatedVulnerabilities() : null).add("Vendor", (Object)this.vendor()).add("ReferenceUrls", this.hasReferenceUrls() ? this.referenceUrls() : null).add("FixAvailable", (Object)this.fixAvailableAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "VulnerablePackages": {
                return Optional.ofNullable(clazz.cast(this.vulnerablePackages()));
            }
            case "Cvss": {
                return Optional.ofNullable(clazz.cast(this.cvss()));
            }
            case "RelatedVulnerabilities": {
                return Optional.ofNullable(clazz.cast(this.relatedVulnerabilities()));
            }
            case "Vendor": {
                return Optional.ofNullable(clazz.cast(this.vendor()));
            }
            case "ReferenceUrls": {
                return Optional.ofNullable(clazz.cast(this.referenceUrls()));
            }
            case "FixAvailable": {
                return Optional.ofNullable(clazz.cast(this.fixAvailableAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vulnerability, T> g) {
        return obj -> g.apply((Vulnerability)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<SoftwarePackage> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();
        private List<Cvss> cvss = DefaultSdkAutoConstructList.getInstance();
        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();
        private VulnerabilityVendor vendor;
        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();
        private String fixAvailable;

        private BuilderImpl() {
        }

        private BuilderImpl(Vulnerability model) {
            this.id(model.id);
            this.vulnerablePackages(model.vulnerablePackages);
            this.cvss(model.cvss);
            this.relatedVulnerabilities(model.relatedVulnerabilities);
            this.vendor(model.vendor);
            this.referenceUrls(model.referenceUrls);
            this.fixAvailable(model.fixAvailable);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<SoftwarePackage.Builder> getVulnerablePackages() {
            List<SoftwarePackage.Builder> result = SoftwarePackageListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVulnerablePackages(Collection<SoftwarePackage.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = SoftwarePackageListCopier.copyFromBuilder(vulnerablePackages);
        }

        @Override
        public final Builder vulnerablePackages(Collection<SoftwarePackage> vulnerablePackages) {
            this.vulnerablePackages = SoftwarePackageListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(SoftwarePackage ... vulnerablePackages) {
            this.vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<SoftwarePackage.Builder> ... vulnerablePackages) {
            this.vulnerablePackages(Stream.of(vulnerablePackages).map(c -> (SoftwarePackage)((SoftwarePackage.Builder)SoftwarePackage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Cvss.Builder> getCvss() {
            List<Cvss.Builder> result = CvssListCopier.copyToBuilder(this.cvss);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCvss(Collection<Cvss.BuilderImpl> cvss) {
            this.cvss = CvssListCopier.copyFromBuilder(cvss);
        }

        @Override
        public final Builder cvss(Collection<Cvss> cvss) {
            this.cvss = CvssListCopier.copy(cvss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Cvss ... cvss) {
            this.cvss(Arrays.asList(cvss));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Consumer<Cvss.Builder> ... cvss) {
            this.cvss(Stream.of(cvss).map(c -> (Cvss)((Cvss.Builder)Cvss.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (this.relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedVulnerabilities;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringListCopier.copy(relatedVulnerabilities);
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String ... relatedVulnerabilities) {
            this.relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final VulnerabilityVendor.Builder getVendor() {
            return this.vendor != null ? this.vendor.toBuilder() : null;
        }

        public final void setVendor(VulnerabilityVendor.BuilderImpl vendor) {
            this.vendor = vendor != null ? vendor.build() : null;
        }

        @Override
        public final Builder vendor(VulnerabilityVendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public final Collection<String> getReferenceUrls() {
            if (this.referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return this.referenceUrls;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = StringListCopier.copy(referenceUrls);
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = StringListCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String ... referenceUrls) {
            this.referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final String getFixAvailable() {
            return this.fixAvailable;
        }

        public final void setFixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
        }

        @Override
        public final Builder fixAvailable(String fixAvailable) {
            this.fixAvailable = fixAvailable;
            return this;
        }

        @Override
        public final Builder fixAvailable(VulnerabilityFixAvailable fixAvailable) {
            this.fixAvailable(fixAvailable == null ? null : fixAvailable.toString());
            return this;
        }

        public Vulnerability build() {
            return new Vulnerability(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Vulnerability> {
        public Builder id(String var1);

        public Builder vulnerablePackages(Collection<SoftwarePackage> var1);

        public Builder vulnerablePackages(SoftwarePackage ... var1);

        public Builder vulnerablePackages(Consumer<SoftwarePackage.Builder> ... var1);

        public Builder cvss(Collection<Cvss> var1);

        public Builder cvss(Cvss ... var1);

        public Builder cvss(Consumer<Cvss.Builder> ... var1);

        public Builder relatedVulnerabilities(Collection<String> var1);

        public Builder relatedVulnerabilities(String ... var1);

        public Builder vendor(VulnerabilityVendor var1);

        default public Builder vendor(Consumer<VulnerabilityVendor.Builder> vendor) {
            return this.vendor((VulnerabilityVendor)((VulnerabilityVendor.Builder)VulnerabilityVendor.builder().applyMutation(vendor)).build());
        }

        public Builder referenceUrls(Collection<String> var1);

        public Builder referenceUrls(String ... var1);

        public Builder fixAvailable(String var1);

        public Builder fixAvailable(VulnerabilityFixAvailable var1);
    }
}

