/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.FindingHistoryRecord;
import software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse;

public class GetFindingHistoryPublisher
implements SdkPublisher<GetFindingHistoryResponse> {
    private final SecurityHubAsyncClient client;
    private final GetFindingHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingHistoryPublisher(SecurityHubAsyncClient client, GetFindingHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingHistoryPublisher(SecurityHubAsyncClient client, GetFindingHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingHistoryRecord> records() {
        Function<GetFindingHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFindingHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFindingHistoryResponseFetcher
    implements AsyncPageFetcher<GetFindingHistoryResponse> {
        private GetFindingHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingHistoryResponse> nextPage(GetFindingHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetFindingHistoryPublisher.this.client.getFindingHistory(GetFindingHistoryPublisher.this.firstRequest);
            }
            return GetFindingHistoryPublisher.this.client.getFindingHistory((GetFindingHistoryRequest)((Object)GetFindingHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

