/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.securityhub.DefaultSecurityHubBaseClientBuilder;
import software.amazon.awssdk.services.securityhub.DefaultSecurityHubClient;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.SecurityHubClientBuilder;
import software.amazon.awssdk.services.securityhub.SecurityHubServiceClientConfiguration;
import software.amazon.awssdk.services.securityhub.endpoints.SecurityHubEndpointProvider;

@SdkInternalApi
final class DefaultSecurityHubClientBuilder
extends DefaultSecurityHubBaseClientBuilder<SecurityHubClientBuilder, SecurityHubClient>
implements SecurityHubClientBuilder {
    DefaultSecurityHubClientBuilder() {
    }

    @Override
    public DefaultSecurityHubClientBuilder endpointProvider(SecurityHubEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SecurityHubClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSecurityHubClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SecurityHubServiceClientConfiguration serviceClientConfiguration = SecurityHubServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSecurityHubClient(serviceClientConfiguration, clientConfiguration);
    }
}

