/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2TransitGatewayDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2TransitGatewayDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::id)).setter(AwsEc2TransitGatewayDetails.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::description)).setter(AwsEc2TransitGatewayDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRouteTablePropagation").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::defaultRouteTablePropagation)).setter(AwsEc2TransitGatewayDetails.setter(Builder::defaultRouteTablePropagation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation").build()}).build();
    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoAcceptSharedAttachments").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::autoAcceptSharedAttachments)).setter(AwsEc2TransitGatewayDetails.setter(Builder::autoAcceptSharedAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments").build()}).build();
    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRouteTableAssociation").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::defaultRouteTableAssociation)).setter(AwsEc2TransitGatewayDetails.setter(Builder::defaultRouteTableAssociation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation").build()}).build();
    private static final SdkField<List<String>> TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayCidrBlocks").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::transitGatewayCidrBlocks)).setter(AwsEc2TransitGatewayDetails.setter(Builder::transitGatewayCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayCidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationDefaultRouteTableId").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::associationDefaultRouteTableId)).setter(AwsEc2TransitGatewayDetails.setter(Builder::associationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropagationDefaultRouteTableId").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::propagationDefaultRouteTableId)).setter(AwsEc2TransitGatewayDetails.setter(Builder::propagationDefaultRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId").build()}).build();
    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnEcmpSupport").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::vpnEcmpSupport)).setter(AwsEc2TransitGatewayDetails.setter(Builder::vpnEcmpSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport").build()}).build();
    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsSupport").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::dnsSupport)).setter(AwsEc2TransitGatewayDetails.setter(Builder::dnsSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").build()}).build();
    private static final SdkField<String> MULTICAST_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MulticastSupport").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::multicastSupport)).setter(AwsEc2TransitGatewayDetails.setter(Builder::multicastSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastSupport").build()}).build();
    private static final SdkField<Integer> AMAZON_SIDE_ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AmazonSideAsn").getter(AwsEc2TransitGatewayDetails.getter(AwsEc2TransitGatewayDetails::amazonSideAsn)).setter(AwsEc2TransitGatewayDetails.setter(Builder::amazonSideAsn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD, DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD, TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD, PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD, MULTICAST_SUPPORT_FIELD, AMAZON_SIDE_ASN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String description;
    private final String defaultRouteTablePropagation;
    private final String autoAcceptSharedAttachments;
    private final String defaultRouteTableAssociation;
    private final List<String> transitGatewayCidrBlocks;
    private final String associationDefaultRouteTableId;
    private final String propagationDefaultRouteTableId;
    private final String vpnEcmpSupport;
    private final String dnsSupport;
    private final String multicastSupport;
    private final Integer amazonSideAsn;

    private AwsEc2TransitGatewayDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.transitGatewayCidrBlocks = builder.transitGatewayCidrBlocks;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.multicastSupport = builder.multicastSupport;
        this.amazonSideAsn = builder.amazonSideAsn;
    }

    public final String id() {
        return this.id;
    }

    public final String description() {
        return this.description;
    }

    public final String defaultRouteTablePropagation() {
        return this.defaultRouteTablePropagation;
    }

    public final String autoAcceptSharedAttachments() {
        return this.autoAcceptSharedAttachments;
    }

    public final String defaultRouteTableAssociation() {
        return this.defaultRouteTableAssociation;
    }

    public final boolean hasTransitGatewayCidrBlocks() {
        return this.transitGatewayCidrBlocks != null && !(this.transitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> transitGatewayCidrBlocks() {
        return this.transitGatewayCidrBlocks;
    }

    public final String associationDefaultRouteTableId() {
        return this.associationDefaultRouteTableId;
    }

    public final String propagationDefaultRouteTableId() {
        return this.propagationDefaultRouteTableId;
    }

    public final String vpnEcmpSupport() {
        return this.vpnEcmpSupport;
    }

    public final String dnsSupport() {
        return this.dnsSupport;
    }

    public final String multicastSupport() {
        return this.multicastSupport;
    }

    public final Integer amazonSideAsn() {
        return this.amazonSideAsn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTablePropagation());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoAcceptSharedAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteTableAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayCidrBlocks() ? this.transitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnEcmpSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonSideAsn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2TransitGatewayDetails)) {
            return false;
        }
        AwsEc2TransitGatewayDetails other = (AwsEc2TransitGatewayDetails)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultRouteTablePropagation(), other.defaultRouteTablePropagation()) && Objects.equals(this.autoAcceptSharedAttachments(), other.autoAcceptSharedAttachments()) && Objects.equals(this.defaultRouteTableAssociation(), other.defaultRouteTableAssociation()) && this.hasTransitGatewayCidrBlocks() == other.hasTransitGatewayCidrBlocks() && Objects.equals(this.transitGatewayCidrBlocks(), other.transitGatewayCidrBlocks()) && Objects.equals(this.associationDefaultRouteTableId(), other.associationDefaultRouteTableId()) && Objects.equals(this.propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId()) && Objects.equals(this.vpnEcmpSupport(), other.vpnEcmpSupport()) && Objects.equals(this.dnsSupport(), other.dnsSupport()) && Objects.equals(this.multicastSupport(), other.multicastSupport()) && Objects.equals(this.amazonSideAsn(), other.amazonSideAsn());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2TransitGatewayDetails").add("Id", (Object)this.id()).add("Description", (Object)this.description()).add("DefaultRouteTablePropagation", (Object)this.defaultRouteTablePropagation()).add("AutoAcceptSharedAttachments", (Object)this.autoAcceptSharedAttachments()).add("DefaultRouteTableAssociation", (Object)this.defaultRouteTableAssociation()).add("TransitGatewayCidrBlocks", this.hasTransitGatewayCidrBlocks() ? this.transitGatewayCidrBlocks() : null).add("AssociationDefaultRouteTableId", (Object)this.associationDefaultRouteTableId()).add("PropagationDefaultRouteTableId", (Object)this.propagationDefaultRouteTableId()).add("VpnEcmpSupport", (Object)this.vpnEcmpSupport()).add("DnsSupport", (Object)this.dnsSupport()).add("MulticastSupport", (Object)this.multicastSupport()).add("AmazonSideAsn", (Object)this.amazonSideAsn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultRouteTablePropagation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTablePropagation()));
            }
            case "AutoAcceptSharedAttachments": {
                return Optional.ofNullable(clazz.cast(this.autoAcceptSharedAttachments()));
            }
            case "DefaultRouteTableAssociation": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteTableAssociation()));
            }
            case "TransitGatewayCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayCidrBlocks()));
            }
            case "AssociationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.associationDefaultRouteTableId()));
            }
            case "PropagationDefaultRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.propagationDefaultRouteTableId()));
            }
            case "VpnEcmpSupport": {
                return Optional.ofNullable(clazz.cast(this.vpnEcmpSupport()));
            }
            case "DnsSupport": {
                return Optional.ofNullable(clazz.cast(this.dnsSupport()));
            }
            case "MulticastSupport": {
                return Optional.ofNullable(clazz.cast(this.multicastSupport()));
            }
            case "AmazonSideAsn": {
                return Optional.ofNullable(clazz.cast(this.amazonSideAsn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2TransitGatewayDetails, T> g) {
        return obj -> g.apply((AwsEc2TransitGatewayDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String description;
        private String defaultRouteTablePropagation;
        private String autoAcceptSharedAttachments;
        private String defaultRouteTableAssociation;
        private List<String> transitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private String associationDefaultRouteTableId;
        private String propagationDefaultRouteTableId;
        private String vpnEcmpSupport;
        private String dnsSupport;
        private String multicastSupport;
        private Integer amazonSideAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2TransitGatewayDetails model) {
            this.id(model.id);
            this.description(model.description);
            this.defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            this.autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            this.defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            this.transitGatewayCidrBlocks(model.transitGatewayCidrBlocks);
            this.associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            this.propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            this.vpnEcmpSupport(model.vpnEcmpSupport);
            this.dnsSupport(model.dnsSupport);
            this.multicastSupport(model.multicastSupport);
            this.amazonSideAsn(model.amazonSideAsn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultRouteTablePropagation() {
            return this.defaultRouteTablePropagation;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        public final String getAutoAcceptSharedAttachments() {
            return this.autoAcceptSharedAttachments;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        public final String getDefaultRouteTableAssociation() {
            return this.defaultRouteTableAssociation;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        public final Collection<String> getTransitGatewayCidrBlocks() {
            if (this.transitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.transitGatewayCidrBlocks;
        }

        public final void setTransitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = NonEmptyStringListCopier.copy(transitGatewayCidrBlocks);
        }

        @Override
        public final Builder transitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = NonEmptyStringListCopier.copy(transitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayCidrBlocks(String ... transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks(Arrays.asList(transitGatewayCidrBlocks));
            return this;
        }

        public final String getAssociationDefaultRouteTableId() {
            return this.associationDefaultRouteTableId;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final String getPropagationDefaultRouteTableId() {
            return this.propagationDefaultRouteTableId;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final String getVpnEcmpSupport() {
            return this.vpnEcmpSupport;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        public final String getDnsSupport() {
            return this.dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        public final String getMulticastSupport() {
            return this.multicastSupport;
        }

        public final void setMulticastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
        }

        @Override
        public final Builder multicastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
            return this;
        }

        public final Integer getAmazonSideAsn() {
            return this.amazonSideAsn;
        }

        public final void setAmazonSideAsn(Integer amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Integer amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        public AwsEc2TransitGatewayDetails build() {
            return new AwsEc2TransitGatewayDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2TransitGatewayDetails> {
        public Builder id(String var1);

        public Builder description(String var1);

        public Builder defaultRouteTablePropagation(String var1);

        public Builder autoAcceptSharedAttachments(String var1);

        public Builder defaultRouteTableAssociation(String var1);

        public Builder transitGatewayCidrBlocks(Collection<String> var1);

        public Builder transitGatewayCidrBlocks(String ... var1);

        public Builder associationDefaultRouteTableId(String var1);

        public Builder propagationDefaultRouteTableId(String var1);

        public Builder vpnEcmpSupport(String var1);

        public Builder dnsSupport(String var1);

        public Builder multicastSupport(String var1);

        public Builder amazonSideAsn(Integer var1);
    }
}

