/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SoftwarePackage;

final class SoftwarePackageListCopier {
    SoftwarePackageListCopier() {
    }

    static List<SoftwarePackage> copy(Collection<? extends SoftwarePackage> softwarePackageListParam) {
        Object list;
        if (softwarePackageListParam == null || softwarePackageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            softwarePackageListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SoftwarePackage> copyFromBuilder(Collection<? extends SoftwarePackage.Builder> softwarePackageListParam) {
        Object list;
        if (softwarePackageListParam == null || softwarePackageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            softwarePackageListParam.forEach(entry -> {
                SoftwarePackage member = entry == null ? null : (SoftwarePackage)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SoftwarePackage.Builder> copyToBuilder(Collection<? extends SoftwarePackage> softwarePackageListParam) {
        Object list;
        if (softwarePackageListParam == null || softwarePackageListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            softwarePackageListParam.forEach(entry -> {
                SoftwarePackage.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

