/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ControlStatus;
import software.amazon.awssdk.services.securityhub.model.RelatedRequirementsListCopier;
import software.amazon.awssdk.services.securityhub.model.SeverityRating;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardsControl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardsControl> {
    private static final SdkField<String> STANDARDS_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsControlArn").getter(StandardsControl.getter(StandardsControl::standardsControlArn)).setter(StandardsControl.setter(Builder::standardsControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlArn").build()}).build();
    private static final SdkField<String> CONTROL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlStatus").getter(StandardsControl.getter(StandardsControl::controlStatusAsString)).setter(StandardsControl.setter(Builder::controlStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlStatus").build()}).build();
    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisabledReason").getter(StandardsControl.getter(StandardsControl::disabledReason)).setter(StandardsControl.setter(Builder::disabledReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()}).build();
    private static final SdkField<Instant> CONTROL_STATUS_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ControlStatusUpdatedAt").getter(StandardsControl.getter(StandardsControl::controlStatusUpdatedAt)).setter(StandardsControl.setter(Builder::controlStatusUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlStatusUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlId").getter(StandardsControl.getter(StandardsControl::controlId)).setter(StandardsControl.setter(Builder::controlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(StandardsControl.getter(StandardsControl::title)).setter(StandardsControl.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StandardsControl.getter(StandardsControl::description)).setter(StandardsControl.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> REMEDIATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemediationUrl").getter(StandardsControl.getter(StandardsControl::remediationUrl)).setter(StandardsControl.setter(Builder::remediationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationUrl").build()}).build();
    private static final SdkField<String> SEVERITY_RATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SeverityRating").getter(StandardsControl.getter(StandardsControl::severityRatingAsString)).setter(StandardsControl.setter(Builder::severityRating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityRating").build()}).build();
    private static final SdkField<List<String>> RELATED_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedRequirements").getter(StandardsControl.getter(StandardsControl::relatedRequirements)).setter(StandardsControl.setter(Builder::relatedRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ARN_FIELD, CONTROL_STATUS_FIELD, DISABLED_REASON_FIELD, CONTROL_STATUS_UPDATED_AT_FIELD, CONTROL_ID_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, REMEDIATION_URL_FIELD, SEVERITY_RATING_FIELD, RELATED_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String standardsControlArn;
    private final String controlStatus;
    private final String disabledReason;
    private final Instant controlStatusUpdatedAt;
    private final String controlId;
    private final String title;
    private final String description;
    private final String remediationUrl;
    private final String severityRating;
    private final List<String> relatedRequirements;

    private StandardsControl(BuilderImpl builder) {
        this.standardsControlArn = builder.standardsControlArn;
        this.controlStatus = builder.controlStatus;
        this.disabledReason = builder.disabledReason;
        this.controlStatusUpdatedAt = builder.controlStatusUpdatedAt;
        this.controlId = builder.controlId;
        this.title = builder.title;
        this.description = builder.description;
        this.remediationUrl = builder.remediationUrl;
        this.severityRating = builder.severityRating;
        this.relatedRequirements = builder.relatedRequirements;
    }

    public final String standardsControlArn() {
        return this.standardsControlArn;
    }

    public final ControlStatus controlStatus() {
        return ControlStatus.fromValue(this.controlStatus);
    }

    public final String controlStatusAsString() {
        return this.controlStatus;
    }

    public final String disabledReason() {
        return this.disabledReason;
    }

    public final Instant controlStatusUpdatedAt() {
        return this.controlStatusUpdatedAt;
    }

    public final String controlId() {
        return this.controlId;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String remediationUrl() {
        return this.remediationUrl;
    }

    public final SeverityRating severityRating() {
        return SeverityRating.fromValue(this.severityRating);
    }

    public final String severityRatingAsString() {
        return this.severityRating;
    }

    public final boolean hasRelatedRequirements() {
        return this.relatedRequirements != null && !(this.relatedRequirements instanceof SdkAutoConstructList);
    }

    public final List<String> relatedRequirements() {
        return this.relatedRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlStatusUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityRatingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedRequirements() ? this.relatedRequirements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsControl)) {
            return false;
        }
        StandardsControl other = (StandardsControl)obj;
        return Objects.equals(this.standardsControlArn(), other.standardsControlArn()) && Objects.equals(this.controlStatusAsString(), other.controlStatusAsString()) && Objects.equals(this.disabledReason(), other.disabledReason()) && Objects.equals(this.controlStatusUpdatedAt(), other.controlStatusUpdatedAt()) && Objects.equals(this.controlId(), other.controlId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.remediationUrl(), other.remediationUrl()) && Objects.equals(this.severityRatingAsString(), other.severityRatingAsString()) && this.hasRelatedRequirements() == other.hasRelatedRequirements() && Objects.equals(this.relatedRequirements(), other.relatedRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"StandardsControl").add("StandardsControlArn", (Object)this.standardsControlArn()).add("ControlStatus", (Object)this.controlStatusAsString()).add("DisabledReason", (Object)this.disabledReason()).add("ControlStatusUpdatedAt", (Object)this.controlStatusUpdatedAt()).add("ControlId", (Object)this.controlId()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("RemediationUrl", (Object)this.remediationUrl()).add("SeverityRating", (Object)this.severityRatingAsString()).add("RelatedRequirements", this.hasRelatedRequirements() ? this.relatedRequirements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlArn": {
                return Optional.ofNullable(clazz.cast(this.standardsControlArn()));
            }
            case "ControlStatus": {
                return Optional.ofNullable(clazz.cast(this.controlStatusAsString()));
            }
            case "DisabledReason": {
                return Optional.ofNullable(clazz.cast(this.disabledReason()));
            }
            case "ControlStatusUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.controlStatusUpdatedAt()));
            }
            case "ControlId": {
                return Optional.ofNullable(clazz.cast(this.controlId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "RemediationUrl": {
                return Optional.ofNullable(clazz.cast(this.remediationUrl()));
            }
            case "SeverityRating": {
                return Optional.ofNullable(clazz.cast(this.severityRatingAsString()));
            }
            case "RelatedRequirements": {
                return Optional.ofNullable(clazz.cast(this.relatedRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StandardsControl, T> g) {
        return obj -> g.apply((StandardsControl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standardsControlArn;
        private String controlStatus;
        private String disabledReason;
        private Instant controlStatusUpdatedAt;
        private String controlId;
        private String title;
        private String description;
        private String remediationUrl;
        private String severityRating;
        private List<String> relatedRequirements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsControl model) {
            this.standardsControlArn(model.standardsControlArn);
            this.controlStatus(model.controlStatus);
            this.disabledReason(model.disabledReason);
            this.controlStatusUpdatedAt(model.controlStatusUpdatedAt);
            this.controlId(model.controlId);
            this.title(model.title);
            this.description(model.description);
            this.remediationUrl(model.remediationUrl);
            this.severityRating(model.severityRating);
            this.relatedRequirements(model.relatedRequirements);
        }

        public final String getStandardsControlArn() {
            return this.standardsControlArn;
        }

        public final void setStandardsControlArn(String standardsControlArn) {
            this.standardsControlArn = standardsControlArn;
        }

        @Override
        @Transient
        public final Builder standardsControlArn(String standardsControlArn) {
            this.standardsControlArn = standardsControlArn;
            return this;
        }

        public final String getControlStatus() {
            return this.controlStatus;
        }

        public final void setControlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
        }

        @Override
        @Transient
        public final Builder controlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder controlStatus(ControlStatus controlStatus) {
            this.controlStatus(controlStatus == null ? null : controlStatus.toString());
            return this;
        }

        public final String getDisabledReason() {
            return this.disabledReason;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        @Transient
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final Instant getControlStatusUpdatedAt() {
            return this.controlStatusUpdatedAt;
        }

        public final void setControlStatusUpdatedAt(Instant controlStatusUpdatedAt) {
            this.controlStatusUpdatedAt = controlStatusUpdatedAt;
        }

        @Override
        @Transient
        public final Builder controlStatusUpdatedAt(Instant controlStatusUpdatedAt) {
            this.controlStatusUpdatedAt = controlStatusUpdatedAt;
            return this;
        }

        public final String getControlId() {
            return this.controlId;
        }

        public final void setControlId(String controlId) {
            this.controlId = controlId;
        }

        @Override
        @Transient
        public final Builder controlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRemediationUrl() {
            return this.remediationUrl;
        }

        public final void setRemediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
        }

        @Override
        @Transient
        public final Builder remediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
            return this;
        }

        public final String getSeverityRating() {
            return this.severityRating;
        }

        public final void setSeverityRating(String severityRating) {
            this.severityRating = severityRating;
        }

        @Override
        @Transient
        public final Builder severityRating(String severityRating) {
            this.severityRating = severityRating;
            return this;
        }

        @Override
        @Transient
        public final Builder severityRating(SeverityRating severityRating) {
            this.severityRating(severityRating == null ? null : severityRating.toString());
            return this;
        }

        public final Collection<String> getRelatedRequirements() {
            if (this.relatedRequirements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedRequirements;
        }

        public final void setRelatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
        }

        @Override
        @Transient
        public final Builder relatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder relatedRequirements(String ... relatedRequirements) {
            this.relatedRequirements(Arrays.asList(relatedRequirements));
            return this;
        }

        public StandardsControl build() {
            return new StandardsControl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardsControl> {
        public Builder standardsControlArn(String var1);

        public Builder controlStatus(String var1);

        public Builder controlStatus(ControlStatus var1);

        public Builder disabledReason(String var1);

        public Builder controlStatusUpdatedAt(Instant var1);

        public Builder controlId(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder remediationUrl(String var1);

        public Builder severityRating(String var1);

        public Builder severityRating(SeverityRating var1);

        public Builder relatedRequirements(Collection<String> var1);

        public Builder relatedRequirements(String ... var1);
    }
}

