/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerPath").getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::containerPath)).setter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.setter(Builder::containerPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()}).build();
    private static final SdkField<String> HOST_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostPath").getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::hostPath)).setter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.setter(Builder::hostPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostPath").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails::permissions)).setter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD, HOST_PATH_FIELD, PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerPath;
    private final String hostPath;
    private final List<String> permissions;

    private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.hostPath = builder.hostPath;
        this.permissions = builder.permissions;
    }

    public final String containerPath() {
        return this.containerPath;
    }

    public final String hostPath() {
        return this.hostPath;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails)obj;
        return Objects.equals(this.containerPath(), other.containerPath()) && Objects.equals(this.hostPath(), other.hostPath()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails").add("ContainerPath", (Object)this.containerPath()).add("HostPath", (Object)this.hostPath()).add("Permissions", this.hasPermissions() ? this.permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerPath": {
                return Optional.ofNullable(clazz.cast(this.containerPath()));
            }
            case "HostPath": {
                return Optional.ofNullable(clazz.cast(this.hostPath()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerPath;
        private String hostPath;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails model) {
            this.containerPath(model.containerPath);
            this.hostPath(model.hostPath);
            this.permissions(model.permissions);
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final String getHostPath() {
            return this.hostPath;
        }

        @Override
        public final Builder hostPath(String hostPath) {
            this.hostPath = hostPath;
            return this;
        }

        public final void setHostPath(String hostPath) {
            this.hostPath = hostPath;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = NonEmptyStringListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = NonEmptyStringListCopier.copy(permissions);
        }

        public AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDevicesDetails> {
        public Builder containerPath(String var1);

        public Builder hostPath(String var1);

        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);
    }
}

