/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLink;
import software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSetting;
import software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentOptionSettingsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElasticBeanstalkEnvironmentTier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElasticBeanstalkEnvironmentDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElasticBeanstalkEnvironmentDetails> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::applicationName)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> CNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cname").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::cname)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::cname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cname").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateCreated").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::dateCreated)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<String> DATE_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DateUpdated").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::dateUpdated)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::dateUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateUpdated").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::description)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointUrl").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::endpointUrl)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::endpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentArn").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::environmentArn)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::environmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentArn").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentId").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::environmentId)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentId").build()}).build();
    private static final SdkField<List<AwsElasticBeanstalkEnvironmentEnvironmentLink>> ENVIRONMENT_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnvironmentLinks").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::environmentLinks)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::environmentLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElasticBeanstalkEnvironmentEnvironmentLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::environmentName)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<List<AwsElasticBeanstalkEnvironmentOptionSetting>> OPTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionSettings").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::optionSettings)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::optionSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElasticBeanstalkEnvironmentOptionSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::platformArn)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionStackName").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::solutionStackName)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::status)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<AwsElasticBeanstalkEnvironmentTier> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tier").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::tier)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::tier)).constructor(AwsElasticBeanstalkEnvironmentTier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(AwsElasticBeanstalkEnvironmentDetails.getter(AwsElasticBeanstalkEnvironmentDetails::versionLabel)).setter(AwsElasticBeanstalkEnvironmentDetails.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CNAME_FIELD, DATE_CREATED_FIELD, DATE_UPDATED_FIELD, DESCRIPTION_FIELD, ENDPOINT_URL_FIELD, ENVIRONMENT_ARN_FIELD, ENVIRONMENT_ID_FIELD, ENVIRONMENT_LINKS_FIELD, ENVIRONMENT_NAME_FIELD, OPTION_SETTINGS_FIELD, PLATFORM_ARN_FIELD, SOLUTION_STACK_NAME_FIELD, STATUS_FIELD, TIER_FIELD, VERSION_LABEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String cname;
    private final String dateCreated;
    private final String dateUpdated;
    private final String description;
    private final String endpointUrl;
    private final String environmentArn;
    private final String environmentId;
    private final List<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks;
    private final String environmentName;
    private final List<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings;
    private final String platformArn;
    private final String solutionStackName;
    private final String status;
    private final AwsElasticBeanstalkEnvironmentTier tier;
    private final String versionLabel;

    private AwsElasticBeanstalkEnvironmentDetails(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.cname = builder.cname;
        this.dateCreated = builder.dateCreated;
        this.dateUpdated = builder.dateUpdated;
        this.description = builder.description;
        this.endpointUrl = builder.endpointUrl;
        this.environmentArn = builder.environmentArn;
        this.environmentId = builder.environmentId;
        this.environmentLinks = builder.environmentLinks;
        this.environmentName = builder.environmentName;
        this.optionSettings = builder.optionSettings;
        this.platformArn = builder.platformArn;
        this.solutionStackName = builder.solutionStackName;
        this.status = builder.status;
        this.tier = builder.tier;
        this.versionLabel = builder.versionLabel;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String cname() {
        return this.cname;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final String dateUpdated() {
        return this.dateUpdated;
    }

    public final String description() {
        return this.description;
    }

    public final String endpointUrl() {
        return this.endpointUrl;
    }

    public final String environmentArn() {
        return this.environmentArn;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final boolean hasEnvironmentLinks() {
        return this.environmentLinks != null && !(this.environmentLinks instanceof SdkAutoConstructList);
    }

    public final List<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks() {
        return this.environmentLinks;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final boolean hasOptionSettings() {
        return this.optionSettings != null && !(this.optionSettings instanceof SdkAutoConstructList);
    }

    public final List<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public final String platformArn() {
        return this.platformArn;
    }

    public final String solutionStackName() {
        return this.solutionStackName;
    }

    public final String status() {
        return this.status;
    }

    public final AwsElasticBeanstalkEnvironmentTier tier() {
        return this.tier;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cname());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentLinks() ? this.environmentLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionSettings() ? this.optionSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.tier());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticBeanstalkEnvironmentDetails)) {
            return false;
        }
        AwsElasticBeanstalkEnvironmentDetails other = (AwsElasticBeanstalkEnvironmentDetails)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.cname(), other.cname()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateUpdated(), other.dateUpdated()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointUrl(), other.endpointUrl()) && Objects.equals(this.environmentArn(), other.environmentArn()) && Objects.equals(this.environmentId(), other.environmentId()) && this.hasEnvironmentLinks() == other.hasEnvironmentLinks() && Objects.equals(this.environmentLinks(), other.environmentLinks()) && Objects.equals(this.environmentName(), other.environmentName()) && this.hasOptionSettings() == other.hasOptionSettings() && Objects.equals(this.optionSettings(), other.optionSettings()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.tier(), other.tier()) && Objects.equals(this.versionLabel(), other.versionLabel());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElasticBeanstalkEnvironmentDetails").add("ApplicationName", (Object)this.applicationName()).add("Cname", (Object)this.cname()).add("DateCreated", (Object)this.dateCreated()).add("DateUpdated", (Object)this.dateUpdated()).add("Description", (Object)this.description()).add("EndpointUrl", (Object)this.endpointUrl()).add("EnvironmentArn", (Object)this.environmentArn()).add("EnvironmentId", (Object)this.environmentId()).add("EnvironmentLinks", this.hasEnvironmentLinks() ? this.environmentLinks() : null).add("EnvironmentName", (Object)this.environmentName()).add("OptionSettings", this.hasOptionSettings() ? this.optionSettings() : null).add("PlatformArn", (Object)this.platformArn()).add("SolutionStackName", (Object)this.solutionStackName()).add("Status", (Object)this.status()).add("Tier", (Object)this.tier()).add("VersionLabel", (Object)this.versionLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "Cname": {
                return Optional.ofNullable(clazz.cast(this.cname()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateUpdated": {
                return Optional.ofNullable(clazz.cast(this.dateUpdated()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.endpointUrl()));
            }
            case "EnvironmentArn": {
                return Optional.ofNullable(clazz.cast(this.environmentArn()));
            }
            case "EnvironmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "EnvironmentLinks": {
                return Optional.ofNullable(clazz.cast(this.environmentLinks()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "OptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionSettings()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tier()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticBeanstalkEnvironmentDetails, T> g) {
        return obj -> g.apply((AwsElasticBeanstalkEnvironmentDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String cname;
        private String dateCreated;
        private String dateUpdated;
        private String description;
        private String endpointUrl;
        private String environmentArn;
        private String environmentId;
        private List<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks = DefaultSdkAutoConstructList.getInstance();
        private String environmentName;
        private List<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();
        private String platformArn;
        private String solutionStackName;
        private String status;
        private AwsElasticBeanstalkEnvironmentTier tier;
        private String versionLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticBeanstalkEnvironmentDetails model) {
            this.applicationName(model.applicationName);
            this.cname(model.cname);
            this.dateCreated(model.dateCreated);
            this.dateUpdated(model.dateUpdated);
            this.description(model.description);
            this.endpointUrl(model.endpointUrl);
            this.environmentArn(model.environmentArn);
            this.environmentId(model.environmentId);
            this.environmentLinks(model.environmentLinks);
            this.environmentName(model.environmentName);
            this.optionSettings(model.optionSettings);
            this.platformArn(model.platformArn);
            this.solutionStackName(model.solutionStackName);
            this.status(model.status);
            this.tier(model.tier);
            this.versionLabel(model.versionLabel);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getCname() {
            return this.cname;
        }

        public final void setCname(String cname) {
            this.cname = cname;
        }

        @Override
        @Transient
        public final Builder cname(String cname) {
            this.cname = cname;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final String getDateUpdated() {
            return this.dateUpdated;
        }

        public final void setDateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
        }

        @Override
        @Transient
        public final Builder dateUpdated(String dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        @Transient
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final String getEnvironmentArn() {
            return this.environmentArn;
        }

        public final void setEnvironmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
        }

        @Override
        @Transient
        public final Builder environmentArn(String environmentArn) {
            this.environmentArn = environmentArn;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        @Transient
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final List<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder> getEnvironmentLinks() {
            List<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder> result = AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier.copyToBuilder(this.environmentLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentLinks(Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink.BuilderImpl> environmentLinks) {
            this.environmentLinks = AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier.copyFromBuilder(environmentLinks);
        }

        @Override
        @Transient
        public final Builder environmentLinks(Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink> environmentLinks) {
            this.environmentLinks = AwsElasticBeanstalkEnvironmentEnvironmentLinksCopier.copy(environmentLinks);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentLinks(AwsElasticBeanstalkEnvironmentEnvironmentLink ... environmentLinks) {
            this.environmentLinks(Arrays.asList(environmentLinks));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder environmentLinks(Consumer<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder> ... environmentLinks) {
            this.environmentLinks(Stream.of(environmentLinks).map(c -> (AwsElasticBeanstalkEnvironmentEnvironmentLink)((AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder)AwsElasticBeanstalkEnvironmentEnvironmentLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        @Transient
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final List<AwsElasticBeanstalkEnvironmentOptionSetting.Builder> getOptionSettings() {
            List<AwsElasticBeanstalkEnvironmentOptionSetting.Builder> result = AwsElasticBeanstalkEnvironmentOptionSettingsCopier.copyToBuilder(this.optionSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionSettings(Collection<AwsElasticBeanstalkEnvironmentOptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = AwsElasticBeanstalkEnvironmentOptionSettingsCopier.copyFromBuilder(optionSettings);
        }

        @Override
        @Transient
        public final Builder optionSettings(Collection<AwsElasticBeanstalkEnvironmentOptionSetting> optionSettings) {
            this.optionSettings = AwsElasticBeanstalkEnvironmentOptionSettingsCopier.copy(optionSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionSettings(AwsElasticBeanstalkEnvironmentOptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder optionSettings(Consumer<AwsElasticBeanstalkEnvironmentOptionSetting.Builder> ... optionSettings) {
            this.optionSettings(Stream.of(optionSettings).map(c -> (AwsElasticBeanstalkEnvironmentOptionSetting)((AwsElasticBeanstalkEnvironmentOptionSetting.Builder)AwsElasticBeanstalkEnvironmentOptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        @Transient
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        @Transient
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final AwsElasticBeanstalkEnvironmentTier.Builder getTier() {
            return this.tier != null ? this.tier.toBuilder() : null;
        }

        public final void setTier(AwsElasticBeanstalkEnvironmentTier.BuilderImpl tier) {
            this.tier = tier != null ? tier.build() : null;
        }

        @Override
        @Transient
        public final Builder tier(AwsElasticBeanstalkEnvironmentTier tier) {
            this.tier = tier;
            return this;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        @Transient
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public AwsElasticBeanstalkEnvironmentDetails build() {
            return new AwsElasticBeanstalkEnvironmentDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElasticBeanstalkEnvironmentDetails> {
        public Builder applicationName(String var1);

        public Builder cname(String var1);

        public Builder dateCreated(String var1);

        public Builder dateUpdated(String var1);

        public Builder description(String var1);

        public Builder endpointUrl(String var1);

        public Builder environmentArn(String var1);

        public Builder environmentId(String var1);

        public Builder environmentLinks(Collection<AwsElasticBeanstalkEnvironmentEnvironmentLink> var1);

        public Builder environmentLinks(AwsElasticBeanstalkEnvironmentEnvironmentLink ... var1);

        public Builder environmentLinks(Consumer<AwsElasticBeanstalkEnvironmentEnvironmentLink.Builder> ... var1);

        public Builder environmentName(String var1);

        public Builder optionSettings(Collection<AwsElasticBeanstalkEnvironmentOptionSetting> var1);

        public Builder optionSettings(AwsElasticBeanstalkEnvironmentOptionSetting ... var1);

        public Builder optionSettings(Consumer<AwsElasticBeanstalkEnvironmentOptionSetting.Builder> ... var1);

        public Builder platformArn(String var1);

        public Builder solutionStackName(String var1);

        public Builder status(String var1);

        public Builder tier(AwsElasticBeanstalkEnvironmentTier var1);

        default public Builder tier(Consumer<AwsElasticBeanstalkEnvironmentTier.Builder> tier) {
            return this.tier((AwsElasticBeanstalkEnvironmentTier)((AwsElasticBeanstalkEnvironmentTier.Builder)AwsElasticBeanstalkEnvironmentTier.builder().applyMutation(tier)).build());
        }

        public Builder versionLabel(String var1);
    }
}

