/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.DataClassificationDetails;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.services.securityhub.model.Partition;
import software.amazon.awssdk.services.securityhub.model.ResourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Resource.getter(Resource::type)).setter(Resource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Resource.getter(Resource::id)).setter(Resource.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Partition").getter(Resource.getter(Resource::partitionAsString)).setter(Resource.setter(Builder::partition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Resource.getter(Resource::region)).setter(Resource.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRole").getter(Resource.getter(Resource::resourceRole)).setter(Resource.setter(Builder::resourceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Resource.getter(Resource::tags)).setter(Resource.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DataClassificationDetails> DATA_CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataClassification").getter(Resource.getter(Resource::dataClassification)).setter(Resource.setter(Builder::dataClassification)).constructor(DataClassificationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataClassification").build()}).build();
    private static final SdkField<ResourceDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(Resource.getter(Resource::details)).setter(Resource.setter(Builder::details)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD, PARTITION_FIELD, REGION_FIELD, RESOURCE_ROLE_FIELD, TAGS_FIELD, DATA_CLASSIFICATION_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String id;
    private final String partition;
    private final String region;
    private final String resourceRole;
    private final Map<String, String> tags;
    private final DataClassificationDetails dataClassification;
    private final ResourceDetails details;

    private Resource(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.partition = builder.partition;
        this.region = builder.region;
        this.resourceRole = builder.resourceRole;
        this.tags = builder.tags;
        this.dataClassification = builder.dataClassification;
        this.details = builder.details;
    }

    public final String type() {
        return this.type;
    }

    public final String id() {
        return this.id;
    }

    public final Partition partition() {
        return Partition.fromValue(this.partition);
    }

    public final String partitionAsString() {
        return this.partition;
    }

    public final String region() {
        return this.region;
    }

    public final String resourceRole() {
        return this.resourceRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final DataClassificationDetails dataClassification() {
        return this.dataClassification;
    }

    public final ResourceDetails details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataClassification());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.partitionAsString(), other.partitionAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceRole(), other.resourceRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dataClassification(), other.dataClassification()) && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"Resource").add("Type", (Object)this.type()).add("Id", (Object)this.id()).add("Partition", (Object)this.partitionAsString()).add("Region", (Object)this.region()).add("ResourceRole", (Object)this.resourceRole()).add("Tags", this.hasTags() ? this.tags() : null).add("DataClassification", (Object)this.dataClassification()).add("Details", (Object)this.details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Partition": {
                return Optional.ofNullable(clazz.cast(this.partitionAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ResourceRole": {
                return Optional.ofNullable(clazz.cast(this.resourceRole()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DataClassification": {
                return Optional.ofNullable(clazz.cast(this.dataClassification()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private String partition;
        private String region;
        private String resourceRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private DataClassificationDetails dataClassification;
        private ResourceDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.type(model.type);
            this.id(model.id);
            this.partition(model.partition);
            this.region(model.region);
            this.resourceRole(model.resourceRole);
            this.tags(model.tags);
            this.dataClassification(model.dataClassification);
            this.details(model.details);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPartition() {
            return this.partition;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        @Override
        @Transient
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        @Override
        @Transient
        public final Builder partition(Partition partition) {
            this.partition(partition == null ? null : partition.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        @Override
        @Transient
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
            return this;
        }

        public final DataClassificationDetails.Builder getDataClassification() {
            return this.dataClassification != null ? this.dataClassification.toBuilder() : null;
        }

        public final void setDataClassification(DataClassificationDetails.BuilderImpl dataClassification) {
            this.dataClassification = dataClassification != null ? dataClassification.build() : null;
        }

        @Override
        @Transient
        public final Builder dataClassification(DataClassificationDetails dataClassification) {
            this.dataClassification = dataClassification;
            return this;
        }

        public final ResourceDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(ResourceDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        @Transient
        public final Builder details(ResourceDetails details) {
            this.details = details;
            return this;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder type(String var1);

        public Builder id(String var1);

        public Builder partition(String var1);

        public Builder partition(Partition var1);

        public Builder region(String var1);

        public Builder resourceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder dataClassification(DataClassificationDetails var1);

        default public Builder dataClassification(Consumer<DataClassificationDetails.Builder> dataClassification) {
            return this.dataClassification((DataClassificationDetails)((DataClassificationDetails.Builder)DataClassificationDetails.builder().applyMutation(dataClassification)).build());
        }

        public Builder details(ResourceDetails var1);

        default public Builder details(Consumer<ResourceDetails.Builder> details) {
            return this.details((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(details)).build());
        }
    }
}

