/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.CategoryListCopier;
import software.amazon.awssdk.services.securityhub.model.IntegrationType;
import software.amazon.awssdk.services.securityhub.model.IntegrationTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Product
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Product> {
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductArn").getter(Product.getter(Product::productArn)).setter(Product.setter(Builder::productArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()}).build();
    private static final SdkField<String> PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductName").getter(Product.getter(Product::productName)).setter(Product.setter(Builder::productName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductName").build()}).build();
    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompanyName").getter(Product.getter(Product::companyName)).setter(Product.setter(Builder::companyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Product.getter(Product::description)).setter(Product.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Categories").getter(Product.getter(Product::categories)).setter(Product.setter(Builder::categories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Categories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INTEGRATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegrationTypes").getter(Product.getter(Product::integrationTypesAsStrings)).setter(Product.setter(Builder::integrationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKETPLACE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarketplaceUrl").getter(Product.getter(Product::marketplaceUrl)).setter(Product.setter(Builder::marketplaceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceUrl").build()}).build();
    private static final SdkField<String> ACTIVATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationUrl").getter(Product.getter(Product::activationUrl)).setter(Product.setter(Builder::activationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationUrl").build()}).build();
    private static final SdkField<String> PRODUCT_SUBSCRIPTION_RESOURCE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductSubscriptionResourcePolicy").getter(Product.getter(Product::productSubscriptionResourcePolicy)).setter(Product.setter(Builder::productSubscriptionResourcePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSubscriptionResourcePolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ARN_FIELD, PRODUCT_NAME_FIELD, COMPANY_NAME_FIELD, DESCRIPTION_FIELD, CATEGORIES_FIELD, INTEGRATION_TYPES_FIELD, MARKETPLACE_URL_FIELD, ACTIVATION_URL_FIELD, PRODUCT_SUBSCRIPTION_RESOURCE_POLICY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productArn;
    private final String productName;
    private final String companyName;
    private final String description;
    private final List<String> categories;
    private final List<String> integrationTypes;
    private final String marketplaceUrl;
    private final String activationUrl;
    private final String productSubscriptionResourcePolicy;

    private Product(BuilderImpl builder) {
        this.productArn = builder.productArn;
        this.productName = builder.productName;
        this.companyName = builder.companyName;
        this.description = builder.description;
        this.categories = builder.categories;
        this.integrationTypes = builder.integrationTypes;
        this.marketplaceUrl = builder.marketplaceUrl;
        this.activationUrl = builder.activationUrl;
        this.productSubscriptionResourcePolicy = builder.productSubscriptionResourcePolicy;
    }

    public final String productArn() {
        return this.productArn;
    }

    public final String productName() {
        return this.productName;
    }

    public final String companyName() {
        return this.companyName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasCategories() {
        return this.categories != null && !(this.categories instanceof SdkAutoConstructList);
    }

    public final List<String> categories() {
        return this.categories;
    }

    public final List<IntegrationType> integrationTypes() {
        return IntegrationTypeListCopier.copyStringToEnum(this.integrationTypes);
    }

    public final boolean hasIntegrationTypes() {
        return this.integrationTypes != null && !(this.integrationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> integrationTypesAsStrings() {
        return this.integrationTypes;
    }

    public final String marketplaceUrl() {
        return this.marketplaceUrl;
    }

    public final String activationUrl() {
        return this.activationUrl;
    }

    public final String productSubscriptionResourcePolicy() {
        return this.productSubscriptionResourcePolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.productName());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCategories() ? this.categories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationTypes() ? this.integrationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplaceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.productSubscriptionResourcePolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Product)) {
            return false;
        }
        Product other = (Product)obj;
        return Objects.equals(this.productArn(), other.productArn()) && Objects.equals(this.productName(), other.productName()) && Objects.equals(this.companyName(), other.companyName()) && Objects.equals(this.description(), other.description()) && this.hasCategories() == other.hasCategories() && Objects.equals(this.categories(), other.categories()) && this.hasIntegrationTypes() == other.hasIntegrationTypes() && Objects.equals(this.integrationTypesAsStrings(), other.integrationTypesAsStrings()) && Objects.equals(this.marketplaceUrl(), other.marketplaceUrl()) && Objects.equals(this.activationUrl(), other.activationUrl()) && Objects.equals(this.productSubscriptionResourcePolicy(), other.productSubscriptionResourcePolicy());
    }

    public final String toString() {
        return ToString.builder((String)"Product").add("ProductArn", (Object)this.productArn()).add("ProductName", (Object)this.productName()).add("CompanyName", (Object)this.companyName()).add("Description", (Object)this.description()).add("Categories", this.hasCategories() ? this.categories() : null).add("IntegrationTypes", this.hasIntegrationTypes() ? this.integrationTypesAsStrings() : null).add("MarketplaceUrl", (Object)this.marketplaceUrl()).add("ActivationUrl", (Object)this.activationUrl()).add("ProductSubscriptionResourcePolicy", (Object)this.productSubscriptionResourcePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductArn": {
                return Optional.ofNullable(clazz.cast(this.productArn()));
            }
            case "ProductName": {
                return Optional.ofNullable(clazz.cast(this.productName()));
            }
            case "CompanyName": {
                return Optional.ofNullable(clazz.cast(this.companyName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Categories": {
                return Optional.ofNullable(clazz.cast(this.categories()));
            }
            case "IntegrationTypes": {
                return Optional.ofNullable(clazz.cast(this.integrationTypesAsStrings()));
            }
            case "MarketplaceUrl": {
                return Optional.ofNullable(clazz.cast(this.marketplaceUrl()));
            }
            case "ActivationUrl": {
                return Optional.ofNullable(clazz.cast(this.activationUrl()));
            }
            case "ProductSubscriptionResourcePolicy": {
                return Optional.ofNullable(clazz.cast(this.productSubscriptionResourcePolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Product, T> g) {
        return obj -> g.apply((Product)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productArn;
        private String productName;
        private String companyName;
        private String description;
        private List<String> categories = DefaultSdkAutoConstructList.getInstance();
        private List<String> integrationTypes = DefaultSdkAutoConstructList.getInstance();
        private String marketplaceUrl;
        private String activationUrl;
        private String productSubscriptionResourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(Product model) {
            this.productArn(model.productArn);
            this.productName(model.productName);
            this.companyName(model.companyName);
            this.description(model.description);
            this.categories(model.categories);
            this.integrationTypesWithStrings(model.integrationTypes);
            this.marketplaceUrl(model.marketplaceUrl);
            this.activationUrl(model.activationUrl);
            this.productSubscriptionResourcePolicy(model.productSubscriptionResourcePolicy);
        }

        public final String getProductArn() {
            return this.productArn;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        @Transient
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final String getProductName() {
            return this.productName;
        }

        public final void setProductName(String productName) {
            this.productName = productName;
        }

        @Override
        @Transient
        public final Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        public final String getCompanyName() {
            return this.companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        @Transient
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCategories() {
            if (this.categories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.categories;
        }

        public final void setCategories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
        }

        @Override
        @Transient
        public final Builder categories(Collection<String> categories) {
            this.categories = CategoryListCopier.copy(categories);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder categories(String ... categories) {
            this.categories(Arrays.asList(categories));
            return this;
        }

        public final Collection<String> getIntegrationTypes() {
            if (this.integrationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.integrationTypes;
        }

        public final void setIntegrationTypes(Collection<String> integrationTypes) {
            this.integrationTypes = IntegrationTypeListCopier.copy(integrationTypes);
        }

        @Override
        @Transient
        public final Builder integrationTypesWithStrings(Collection<String> integrationTypes) {
            this.integrationTypes = IntegrationTypeListCopier.copy(integrationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder integrationTypesWithStrings(String ... integrationTypes) {
            this.integrationTypesWithStrings(Arrays.asList(integrationTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder integrationTypes(Collection<IntegrationType> integrationTypes) {
            this.integrationTypes = IntegrationTypeListCopier.copyEnumToString(integrationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder integrationTypes(IntegrationType ... integrationTypes) {
            this.integrationTypes(Arrays.asList(integrationTypes));
            return this;
        }

        public final String getMarketplaceUrl() {
            return this.marketplaceUrl;
        }

        public final void setMarketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
        }

        @Override
        @Transient
        public final Builder marketplaceUrl(String marketplaceUrl) {
            this.marketplaceUrl = marketplaceUrl;
            return this;
        }

        public final String getActivationUrl() {
            return this.activationUrl;
        }

        public final void setActivationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
        }

        @Override
        @Transient
        public final Builder activationUrl(String activationUrl) {
            this.activationUrl = activationUrl;
            return this;
        }

        public final String getProductSubscriptionResourcePolicy() {
            return this.productSubscriptionResourcePolicy;
        }

        public final void setProductSubscriptionResourcePolicy(String productSubscriptionResourcePolicy) {
            this.productSubscriptionResourcePolicy = productSubscriptionResourcePolicy;
        }

        @Override
        @Transient
        public final Builder productSubscriptionResourcePolicy(String productSubscriptionResourcePolicy) {
            this.productSubscriptionResourcePolicy = productSubscriptionResourcePolicy;
            return this;
        }

        public Product build() {
            return new Product(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Product> {
        public Builder productArn(String var1);

        public Builder productName(String var1);

        public Builder companyName(String var1);

        public Builder description(String var1);

        public Builder categories(Collection<String> var1);

        public Builder categories(String ... var1);

        public Builder integrationTypesWithStrings(Collection<String> var1);

        public Builder integrationTypesWithStrings(String ... var1);

        public Builder integrationTypes(Collection<IntegrationType> var1);

        public Builder integrationTypes(IntegrationType ... var1);

        public Builder marketplaceUrl(String var1);

        public Builder activationUrl(String var1);

        public Builder productSubscriptionResourcePolicy(String var1);
    }
}

