/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ClassificationStatus;
import software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersResult;
import software.amazon.awssdk.services.securityhub.model.SensitiveDataResult;
import software.amazon.awssdk.services.securityhub.model.SensitiveDataResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassificationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassificationResult> {
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MimeType").getter(ClassificationResult.getter(ClassificationResult::mimeType)).setter(ClassificationResult.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MimeType").build()}).build();
    private static final SdkField<Long> SIZE_CLASSIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SizeClassified").getter(ClassificationResult.getter(ClassificationResult::sizeClassified)).setter(ClassificationResult.setter(Builder::sizeClassified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeClassified").build()}).build();
    private static final SdkField<Boolean> ADDITIONAL_OCCURRENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdditionalOccurrences").getter(ClassificationResult.getter(ClassificationResult::additionalOccurrences)).setter(ClassificationResult.setter(Builder::additionalOccurrences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalOccurrences").build()}).build();
    private static final SdkField<ClassificationStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(ClassificationResult.getter(ClassificationResult::status)).setter(ClassificationResult.setter(Builder::status)).constructor(ClassificationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<SensitiveDataResult>> SENSITIVE_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SensitiveData").getter(ClassificationResult.getter(ClassificationResult::sensitiveData)).setter(ClassificationResult.setter(Builder::sensitiveData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensitiveData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SensitiveDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomDataIdentifiersResult> CUSTOM_DATA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDataIdentifiers").getter(ClassificationResult.getter(ClassificationResult::customDataIdentifiers)).setter(ClassificationResult.setter(Builder::customDataIdentifiers)).constructor(CustomDataIdentifiersResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDataIdentifiers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIME_TYPE_FIELD, SIZE_CLASSIFIED_FIELD, ADDITIONAL_OCCURRENCES_FIELD, STATUS_FIELD, SENSITIVE_DATA_FIELD, CUSTOM_DATA_IDENTIFIERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mimeType;
    private final Long sizeClassified;
    private final Boolean additionalOccurrences;
    private final ClassificationStatus status;
    private final List<SensitiveDataResult> sensitiveData;
    private final CustomDataIdentifiersResult customDataIdentifiers;

    private ClassificationResult(BuilderImpl builder) {
        this.mimeType = builder.mimeType;
        this.sizeClassified = builder.sizeClassified;
        this.additionalOccurrences = builder.additionalOccurrences;
        this.status = builder.status;
        this.sensitiveData = builder.sensitiveData;
        this.customDataIdentifiers = builder.customDataIdentifiers;
    }

    public final String mimeType() {
        return this.mimeType;
    }

    public final Long sizeClassified() {
        return this.sizeClassified;
    }

    public final Boolean additionalOccurrences() {
        return this.additionalOccurrences;
    }

    public final ClassificationStatus status() {
        return this.status;
    }

    public final boolean hasSensitiveData() {
        return this.sensitiveData != null && !(this.sensitiveData instanceof SdkAutoConstructList);
    }

    public final List<SensitiveDataResult> sensitiveData() {
        return this.sensitiveData;
    }

    public final CustomDataIdentifiersResult customDataIdentifiers() {
        return this.customDataIdentifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeClassified());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalOccurrences());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSensitiveData() ? this.sensitiveData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customDataIdentifiers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationResult)) {
            return false;
        }
        ClassificationResult other = (ClassificationResult)obj;
        return Objects.equals(this.mimeType(), other.mimeType()) && Objects.equals(this.sizeClassified(), other.sizeClassified()) && Objects.equals(this.additionalOccurrences(), other.additionalOccurrences()) && Objects.equals(this.status(), other.status()) && this.hasSensitiveData() == other.hasSensitiveData() && Objects.equals(this.sensitiveData(), other.sensitiveData()) && Objects.equals(this.customDataIdentifiers(), other.customDataIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"ClassificationResult").add("MimeType", (Object)this.mimeType()).add("SizeClassified", (Object)this.sizeClassified()).add("AdditionalOccurrences", (Object)this.additionalOccurrences()).add("Status", (Object)this.status()).add("SensitiveData", this.hasSensitiveData() ? this.sensitiveData() : null).add("CustomDataIdentifiers", (Object)this.customDataIdentifiers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
            case "SizeClassified": {
                return Optional.ofNullable(clazz.cast(this.sizeClassified()));
            }
            case "AdditionalOccurrences": {
                return Optional.ofNullable(clazz.cast(this.additionalOccurrences()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "SensitiveData": {
                return Optional.ofNullable(clazz.cast(this.sensitiveData()));
            }
            case "CustomDataIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.customDataIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationResult, T> g) {
        return obj -> g.apply((ClassificationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mimeType;
        private Long sizeClassified;
        private Boolean additionalOccurrences;
        private ClassificationStatus status;
        private List<SensitiveDataResult> sensitiveData = DefaultSdkAutoConstructList.getInstance();
        private CustomDataIdentifiersResult customDataIdentifiers;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationResult model) {
            this.mimeType(model.mimeType);
            this.sizeClassified(model.sizeClassified);
            this.additionalOccurrences(model.additionalOccurrences);
            this.status(model.status);
            this.sensitiveData(model.sensitiveData);
            this.customDataIdentifiers(model.customDataIdentifiers);
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public final Long getSizeClassified() {
            return this.sizeClassified;
        }

        @Override
        public final Builder sizeClassified(Long sizeClassified) {
            this.sizeClassified = sizeClassified;
            return this;
        }

        public final void setSizeClassified(Long sizeClassified) {
            this.sizeClassified = sizeClassified;
        }

        public final Boolean getAdditionalOccurrences() {
            return this.additionalOccurrences;
        }

        @Override
        public final Builder additionalOccurrences(Boolean additionalOccurrences) {
            this.additionalOccurrences = additionalOccurrences;
            return this;
        }

        public final void setAdditionalOccurrences(Boolean additionalOccurrences) {
            this.additionalOccurrences = additionalOccurrences;
        }

        public final ClassificationStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClassificationStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClassificationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final List<SensitiveDataResult.Builder> getSensitiveData() {
            List<SensitiveDataResult.Builder> result = SensitiveDataResultListCopier.copyToBuilder(this.sensitiveData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sensitiveData(Collection<SensitiveDataResult> sensitiveData) {
            this.sensitiveData = SensitiveDataResultListCopier.copy(sensitiveData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitiveData(SensitiveDataResult ... sensitiveData) {
            this.sensitiveData(Arrays.asList(sensitiveData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensitiveData(Consumer<SensitiveDataResult.Builder> ... sensitiveData) {
            this.sensitiveData(Stream.of(sensitiveData).map(c -> (SensitiveDataResult)((SensitiveDataResult.Builder)SensitiveDataResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSensitiveData(Collection<SensitiveDataResult.BuilderImpl> sensitiveData) {
            this.sensitiveData = SensitiveDataResultListCopier.copyFromBuilder(sensitiveData);
        }

        public final CustomDataIdentifiersResult.Builder getCustomDataIdentifiers() {
            return this.customDataIdentifiers != null ? this.customDataIdentifiers.toBuilder() : null;
        }

        @Override
        public final Builder customDataIdentifiers(CustomDataIdentifiersResult customDataIdentifiers) {
            this.customDataIdentifiers = customDataIdentifiers;
            return this;
        }

        public final void setCustomDataIdentifiers(CustomDataIdentifiersResult.BuilderImpl customDataIdentifiers) {
            this.customDataIdentifiers = customDataIdentifiers != null ? customDataIdentifiers.build() : null;
        }

        public ClassificationResult build() {
            return new ClassificationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassificationResult> {
        public Builder mimeType(String var1);

        public Builder sizeClassified(Long var1);

        public Builder additionalOccurrences(Boolean var1);

        public Builder status(ClassificationStatus var1);

        default public Builder status(Consumer<ClassificationStatus.Builder> status) {
            return this.status((ClassificationStatus)((ClassificationStatus.Builder)ClassificationStatus.builder().applyMutation(status)).build());
        }

        public Builder sensitiveData(Collection<SensitiveDataResult> var1);

        public Builder sensitiveData(SensitiveDataResult ... var1);

        public Builder sensitiveData(Consumer<SensitiveDataResult.Builder> ... var1);

        public Builder customDataIdentifiers(CustomDataIdentifiersResult var1);

        default public Builder customDataIdentifiers(Consumer<CustomDataIdentifiersResult.Builder> customDataIdentifiers) {
            return this.customDataIdentifiers((CustomDataIdentifiersResult)((CustomDataIdentifiersResult.Builder)CustomDataIdentifiersResult.builder().applyMutation(customDataIdentifiers)).build());
        }
    }
}

