/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ControlStatus;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStandardsControlRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateStandardsControlRequest> {
    private static final SdkField<String> STANDARDS_CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsControlArn").getter(UpdateStandardsControlRequest.getter(UpdateStandardsControlRequest::standardsControlArn)).setter(UpdateStandardsControlRequest.setter(Builder::standardsControlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("StandardsControlArn").build()}).build();
    private static final SdkField<String> CONTROL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlStatus").getter(UpdateStandardsControlRequest.getter(UpdateStandardsControlRequest::controlStatusAsString)).setter(UpdateStandardsControlRequest.setter(Builder::controlStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlStatus").build()}).build();
    private static final SdkField<String> DISABLED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisabledReason").getter(UpdateStandardsControlRequest.getter(UpdateStandardsControlRequest::disabledReason)).setter(UpdateStandardsControlRequest.setter(Builder::disabledReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ARN_FIELD, CONTROL_STATUS_FIELD, DISABLED_REASON_FIELD));
    private final String standardsControlArn;
    private final String controlStatus;
    private final String disabledReason;

    private UpdateStandardsControlRequest(BuilderImpl builder) {
        super(builder);
        this.standardsControlArn = builder.standardsControlArn;
        this.controlStatus = builder.controlStatus;
        this.disabledReason = builder.disabledReason;
    }

    public final String standardsControlArn() {
        return this.standardsControlArn;
    }

    public final ControlStatus controlStatus() {
        return ControlStatus.fromValue(this.controlStatus);
    }

    public final String controlStatusAsString() {
        return this.controlStatus;
    }

    public final String disabledReason() {
        return this.disabledReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsControlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.controlStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStandardsControlRequest)) {
            return false;
        }
        UpdateStandardsControlRequest other = (UpdateStandardsControlRequest)((Object)obj);
        return Objects.equals(this.standardsControlArn(), other.standardsControlArn()) && Objects.equals(this.controlStatusAsString(), other.controlStatusAsString()) && Objects.equals(this.disabledReason(), other.disabledReason());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStandardsControlRequest").add("StandardsControlArn", (Object)this.standardsControlArn()).add("ControlStatus", (Object)this.controlStatusAsString()).add("DisabledReason", (Object)this.disabledReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlArn": {
                return Optional.ofNullable(clazz.cast(this.standardsControlArn()));
            }
            case "ControlStatus": {
                return Optional.ofNullable(clazz.cast(this.controlStatusAsString()));
            }
            case "DisabledReason": {
                return Optional.ofNullable(clazz.cast(this.disabledReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStandardsControlRequest, T> g) {
        return obj -> g.apply((UpdateStandardsControlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String standardsControlArn;
        private String controlStatus;
        private String disabledReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStandardsControlRequest model) {
            super(model);
            this.standardsControlArn(model.standardsControlArn);
            this.controlStatus(model.controlStatus);
            this.disabledReason(model.disabledReason);
        }

        public final String getStandardsControlArn() {
            return this.standardsControlArn;
        }

        @Override
        public final Builder standardsControlArn(String standardsControlArn) {
            this.standardsControlArn = standardsControlArn;
            return this;
        }

        public final void setStandardsControlArn(String standardsControlArn) {
            this.standardsControlArn = standardsControlArn;
        }

        public final String getControlStatus() {
            return this.controlStatus;
        }

        @Override
        public final Builder controlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
            return this;
        }

        @Override
        public final Builder controlStatus(ControlStatus controlStatus) {
            this.controlStatus(controlStatus == null ? null : controlStatus.toString());
            return this;
        }

        public final void setControlStatus(String controlStatus) {
            this.controlStatus = controlStatus;
        }

        public final String getDisabledReason() {
            return this.disabledReason;
        }

        @Override
        public final Builder disabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
            return this;
        }

        public final void setDisabledReason(String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStandardsControlRequest build() {
            return new UpdateStandardsControlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStandardsControlRequest> {
        public Builder standardsControlArn(String var1);

        public Builder controlStatus(String var1);

        public Builder controlStatus(ControlStatus var1);

        public Builder disabledReason(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

