/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cell
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cell> {
    private static final SdkField<Long> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Column").getter(Cell.getter(Cell::column)).setter(Cell.setter(Builder::column)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Long> ROW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Row").getter(Cell.getter(Cell::row)).setter(Cell.setter(Builder::row)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Row").build()}).build();
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(Cell.getter(Cell::columnName)).setter(Cell.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<String> CELL_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CellReference").getter(Cell.getter(Cell::cellReference)).setter(Cell.setter(Builder::cellReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellReference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_FIELD, ROW_FIELD, COLUMN_NAME_FIELD, CELL_REFERENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long column;
    private final Long row;
    private final String columnName;
    private final String cellReference;

    private Cell(BuilderImpl builder) {
        this.column = builder.column;
        this.row = builder.row;
        this.columnName = builder.columnName;
        this.cellReference = builder.cellReference;
    }

    public final Long column() {
        return this.column;
    }

    public final Long row() {
        return this.row;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final String cellReference() {
        return this.cellReference;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.row());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.cellReference());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)obj;
        return Objects.equals(this.column(), other.column()) && Objects.equals(this.row(), other.row()) && Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.cellReference(), other.cellReference());
    }

    public final String toString() {
        return ToString.builder((String)"Cell").add("Column", (Object)this.column()).add("Row", (Object)this.row()).add("ColumnName", (Object)this.columnName()).add("CellReference", (Object)this.cellReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "Row": {
                return Optional.ofNullable(clazz.cast(this.row()));
            }
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "CellReference": {
                return Optional.ofNullable(clazz.cast(this.cellReference()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cell, T> g) {
        return obj -> g.apply((Cell)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long column;
        private Long row;
        private String columnName;
        private String cellReference;

        private BuilderImpl() {
        }

        private BuilderImpl(Cell model) {
            this.column(model.column);
            this.row(model.row);
            this.columnName(model.columnName);
            this.cellReference(model.cellReference);
        }

        public final Long getColumn() {
            return this.column;
        }

        @Override
        public final Builder column(Long column) {
            this.column = column;
            return this;
        }

        public final void setColumn(Long column) {
            this.column = column;
        }

        public final Long getRow() {
            return this.row;
        }

        @Override
        public final Builder row(Long row) {
            this.row = row;
            return this;
        }

        public final void setRow(Long row) {
            this.row = row;
        }

        public final String getColumnName() {
            return this.columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public final String getCellReference() {
            return this.cellReference;
        }

        @Override
        public final Builder cellReference(String cellReference) {
            this.cellReference = cellReference;
            return this;
        }

        public final void setCellReference(String cellReference) {
            this.cellReference = cellReference;
        }

        public Cell build() {
            return new Cell(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cell> {
        public Builder column(Long var1);

        public Builder row(Long var1);

        public Builder columnName(String var1);

        public Builder cellReference(String var1);
    }
}

