/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MalwareState {
    OBSERVED("OBSERVED"),
    REMOVAL_FAILED("REMOVAL_FAILED"),
    REMOVED("REMOVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MalwareState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MalwareState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareState> knownValues() {
        return Stream.of(MalwareState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

