/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VerificationState {
    UNKNOWN("UNKNOWN"),
    TRUE_POSITIVE("TRUE_POSITIVE"),
    FALSE_POSITIVE("FALSE_POSITIVE"),
    BENIGN_POSITIVE("BENIGN_POSITIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private VerificationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerificationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(VerificationState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerificationState> knownValues() {
        return Stream.of(VerificationState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

