/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifier;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingIdentifierListCopier;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.services.securityhub.model.NoteUpdate;
import software.amazon.awssdk.services.securityhub.model.RelatedFinding;
import software.amazon.awssdk.services.securityhub.model.RelatedFindingListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.SeverityUpdate;
import software.amazon.awssdk.services.securityhub.model.TypeListCopier;
import software.amazon.awssdk.services.securityhub.model.VerificationState;
import software.amazon.awssdk.services.securityhub.model.WorkflowUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateFindingsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchUpdateFindingsRequest> {
    private static final SdkField<List<AwsSecurityFindingIdentifier>> FINDING_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingIdentifiers").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::findingIdentifiers)).setter(BatchUpdateFindingsRequest.setter(Builder::findingIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsSecurityFindingIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NoteUpdate> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Note").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::note)).setter(BatchUpdateFindingsRequest.setter(Builder::note)).constructor(NoteUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()}).build();
    private static final SdkField<SeverityUpdate> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Severity").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::severity)).setter(BatchUpdateFindingsRequest.setter(Builder::severity)).constructor(SeverityUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerificationState").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::verificationStateAsString)).setter(BatchUpdateFindingsRequest.setter(Builder::verificationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()}).build();
    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Confidence").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::confidence)).setter(BatchUpdateFindingsRequest.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Criticality").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::criticality)).setter(BatchUpdateFindingsRequest.setter(Builder::criticality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Types").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::types)).setter(BatchUpdateFindingsRequest.setter(Builder::types)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserDefinedFields").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::userDefinedFields)).setter(BatchUpdateFindingsRequest.setter(Builder::userDefinedFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<WorkflowUpdate> WORKFLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Workflow").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::workflow)).setter(BatchUpdateFindingsRequest.setter(Builder::workflow)).constructor(WorkflowUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()}).build();
    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedFindings").getter(BatchUpdateFindingsRequest.getter(BatchUpdateFindingsRequest::relatedFindings)).setter(BatchUpdateFindingsRequest.setter(Builder::relatedFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedFinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_IDENTIFIERS_FIELD, NOTE_FIELD, SEVERITY_FIELD, VERIFICATION_STATE_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TYPES_FIELD, USER_DEFINED_FIELDS_FIELD, WORKFLOW_FIELD, RELATED_FINDINGS_FIELD));
    private final List<AwsSecurityFindingIdentifier> findingIdentifiers;
    private final NoteUpdate note;
    private final SeverityUpdate severity;
    private final String verificationState;
    private final Integer confidence;
    private final Integer criticality;
    private final List<String> types;
    private final Map<String, String> userDefinedFields;
    private final WorkflowUpdate workflow;
    private final List<RelatedFinding> relatedFindings;

    private BatchUpdateFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.findingIdentifiers = builder.findingIdentifiers;
        this.note = builder.note;
        this.severity = builder.severity;
        this.verificationState = builder.verificationState;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.types = builder.types;
        this.userDefinedFields = builder.userDefinedFields;
        this.workflow = builder.workflow;
        this.relatedFindings = builder.relatedFindings;
    }

    public boolean hasFindingIdentifiers() {
        return this.findingIdentifiers != null && !(this.findingIdentifiers instanceof SdkAutoConstructList);
    }

    public List<AwsSecurityFindingIdentifier> findingIdentifiers() {
        return this.findingIdentifiers;
    }

    public NoteUpdate note() {
        return this.note;
    }

    public SeverityUpdate severity() {
        return this.severity;
    }

    public VerificationState verificationState() {
        return VerificationState.fromValue(this.verificationState);
    }

    public String verificationStateAsString() {
        return this.verificationState;
    }

    public Integer confidence() {
        return this.confidence;
    }

    public Integer criticality() {
        return this.criticality;
    }

    public boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public List<String> types() {
        return this.types;
    }

    public boolean hasUserDefinedFields() {
        return this.userDefinedFields != null && !(this.userDefinedFields instanceof SdkAutoConstructMap);
    }

    public Map<String, String> userDefinedFields() {
        return this.userDefinedFields;
    }

    public WorkflowUpdate workflow() {
        return this.workflow;
    }

    public boolean hasRelatedFindings() {
        return this.relatedFindings != null && !(this.relatedFindings instanceof SdkAutoConstructList);
    }

    public List<RelatedFinding> relatedFindings() {
        return this.relatedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingIdentifiers() ? this.findingIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.criticality());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserDefinedFields() ? this.userDefinedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedFindings() ? this.relatedFindings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsRequest)) {
            return false;
        }
        BatchUpdateFindingsRequest other = (BatchUpdateFindingsRequest)((Object)obj);
        return this.hasFindingIdentifiers() == other.hasFindingIdentifiers() && Objects.equals(this.findingIdentifiers(), other.findingIdentifiers()) && Objects.equals(this.note(), other.note()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.verificationStateAsString(), other.verificationStateAsString()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.criticality(), other.criticality()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.types(), other.types()) && this.hasUserDefinedFields() == other.hasUserDefinedFields() && Objects.equals(this.userDefinedFields(), other.userDefinedFields()) && Objects.equals(this.workflow(), other.workflow()) && this.hasRelatedFindings() == other.hasRelatedFindings() && Objects.equals(this.relatedFindings(), other.relatedFindings());
    }

    public String toString() {
        return ToString.builder((String)"BatchUpdateFindingsRequest").add("FindingIdentifiers", this.hasFindingIdentifiers() ? this.findingIdentifiers() : null).add("Note", (Object)this.note()).add("Severity", (Object)this.severity()).add("VerificationState", (Object)this.verificationStateAsString()).add("Confidence", (Object)this.confidence()).add("Criticality", (Object)this.criticality()).add("Types", this.hasTypes() ? this.types() : null).add("UserDefinedFields", this.hasUserDefinedFields() ? this.userDefinedFields() : null).add("Workflow", (Object)this.workflow()).add("RelatedFindings", this.hasRelatedFindings() ? this.relatedFindings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FindingIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.findingIdentifiers()));
            }
            case "Note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "VerificationState": {
                return Optional.ofNullable(clazz.cast(this.verificationStateAsString()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "Criticality": {
                return Optional.ofNullable(clazz.cast(this.criticality()));
            }
            case "Types": {
                return Optional.ofNullable(clazz.cast(this.types()));
            }
            case "UserDefinedFields": {
                return Optional.ofNullable(clazz.cast(this.userDefinedFields()));
            }
            case "Workflow": {
                return Optional.ofNullable(clazz.cast(this.workflow()));
            }
            case "RelatedFindings": {
                return Optional.ofNullable(clazz.cast(this.relatedFindings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsRequest, T> g) {
        return obj -> g.apply((BatchUpdateFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<AwsSecurityFindingIdentifier> findingIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private NoteUpdate note;
        private SeverityUpdate severity;
        private String verificationState;
        private Integer confidence;
        private Integer criticality;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();
        private WorkflowUpdate workflow;
        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsRequest model) {
            super(model);
            this.findingIdentifiers(model.findingIdentifiers);
            this.note(model.note);
            this.severity(model.severity);
            this.verificationState(model.verificationState);
            this.confidence(model.confidence);
            this.criticality(model.criticality);
            this.types(model.types);
            this.userDefinedFields(model.userDefinedFields);
            this.workflow(model.workflow);
            this.relatedFindings(model.relatedFindings);
        }

        public final Collection<AwsSecurityFindingIdentifier.Builder> getFindingIdentifiers() {
            if (this.findingIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingIdentifiers != null ? (Collection)this.findingIdentifiers.stream().map(AwsSecurityFindingIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findingIdentifiers(Collection<AwsSecurityFindingIdentifier> findingIdentifiers) {
            this.findingIdentifiers = AwsSecurityFindingIdentifierListCopier.copy(findingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(AwsSecurityFindingIdentifier ... findingIdentifiers) {
            this.findingIdentifiers(Arrays.asList(findingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(Consumer<AwsSecurityFindingIdentifier.Builder> ... findingIdentifiers) {
            this.findingIdentifiers(Stream.of(findingIdentifiers).map(c -> (AwsSecurityFindingIdentifier)((AwsSecurityFindingIdentifier.Builder)AwsSecurityFindingIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindingIdentifiers(Collection<AwsSecurityFindingIdentifier.BuilderImpl> findingIdentifiers) {
            this.findingIdentifiers = AwsSecurityFindingIdentifierListCopier.copyFromBuilder(findingIdentifiers);
        }

        public final NoteUpdate.Builder getNote() {
            return this.note != null ? this.note.toBuilder() : null;
        }

        @Override
        public final Builder note(NoteUpdate note) {
            this.note = note;
            return this;
        }

        public final void setNote(NoteUpdate.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        public final SeverityUpdate.Builder getSeverity() {
            return this.severity != null ? this.severity.toBuilder() : null;
        }

        @Override
        public final Builder severity(SeverityUpdate severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(SeverityUpdate.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        public final String getVerificationState() {
            return this.verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        public final Integer getConfidence() {
            return this.confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        public final Integer getCriticality() {
            return this.criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        public final Map<String, String> getUserDefinedFields() {
            if (this.userDefinedFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userDefinedFields;
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        public final WorkflowUpdate.Builder getWorkflow() {
            return this.workflow != null ? this.workflow.toBuilder() : null;
        }

        @Override
        public final Builder workflow(WorkflowUpdate workflow) {
            this.workflow = workflow;
            return this;
        }

        public final void setWorkflow(WorkflowUpdate.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        public final Collection<RelatedFinding.Builder> getRelatedFindings() {
            if (this.relatedFindings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedFindings != null ? (Collection)this.relatedFindings.stream().map(RelatedFinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding ... relatedFindings) {
            this.relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder> ... relatedFindings) {
            this.relatedFindings(Stream.of(relatedFindings).map(c -> (RelatedFinding)((RelatedFinding.Builder)RelatedFinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateFindingsRequest build() {
            return new BatchUpdateFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateFindingsRequest> {
        public Builder findingIdentifiers(Collection<AwsSecurityFindingIdentifier> var1);

        public Builder findingIdentifiers(AwsSecurityFindingIdentifier ... var1);

        public Builder findingIdentifiers(Consumer<AwsSecurityFindingIdentifier.Builder> ... var1);

        public Builder note(NoteUpdate var1);

        default public Builder note(Consumer<NoteUpdate.Builder> note) {
            return this.note((NoteUpdate)((NoteUpdate.Builder)NoteUpdate.builder().applyMutation(note)).build());
        }

        public Builder severity(SeverityUpdate var1);

        default public Builder severity(Consumer<SeverityUpdate.Builder> severity) {
            return this.severity((SeverityUpdate)((SeverityUpdate.Builder)SeverityUpdate.builder().applyMutation(severity)).build());
        }

        public Builder verificationState(String var1);

        public Builder verificationState(VerificationState var1);

        public Builder confidence(Integer var1);

        public Builder criticality(Integer var1);

        public Builder types(Collection<String> var1);

        public Builder types(String ... var1);

        public Builder userDefinedFields(Map<String, String> var1);

        public Builder workflow(WorkflowUpdate var1);

        default public Builder workflow(Consumer<WorkflowUpdate.Builder> workflow) {
            return this.workflow((WorkflowUpdate)((WorkflowUpdate.Builder)WorkflowUpdate.builder().applyMutation(workflow)).build());
        }

        public Builder relatedFindings(Collection<RelatedFinding> var1);

        public Builder relatedFindings(RelatedFinding ... var1);

        public Builder relatedFindings(Consumer<RelatedFinding.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

