/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Product;
import software.amazon.awssdk.services.securityhub.model.ProductsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeProductsResponse> {
    private static final SdkField<List<Product>> PRODUCTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Products").getter(DescribeProductsResponse.getter(DescribeProductsResponse::products)).setter(DescribeProductsResponse.setter(Builder::products)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Products").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Product::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProductsResponse.getter(DescribeProductsResponse::nextToken)).setter(DescribeProductsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Product> products;
    private final String nextToken;

    private DescribeProductsResponse(BuilderImpl builder) {
        super(builder);
        this.products = builder.products;
        this.nextToken = builder.nextToken;
    }

    public boolean hasProducts() {
        return this.products != null && !(this.products instanceof SdkAutoConstructList);
    }

    public List<Product> products() {
        return this.products;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.products());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductsResponse)) {
            return false;
        }
        DescribeProductsResponse other = (DescribeProductsResponse)((Object)obj);
        return Objects.equals(this.products(), other.products()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProductsResponse").add("Products", this.products()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Products": {
                return Optional.ofNullable(clazz.cast(this.products()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductsResponse, T> g) {
        return obj -> g.apply((DescribeProductsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Product> products = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductsResponse model) {
            super(model);
            this.products(model.products);
            this.nextToken(model.nextToken);
        }

        public final Collection<Product.Builder> getProducts() {
            return this.products != null ? (Collection)this.products.stream().map(Product::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder products(Collection<Product> products) {
            this.products = ProductsListCopier.copy(products);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(Product ... products) {
            this.products(Arrays.asList(products));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder products(Consumer<Product.Builder> ... products) {
            this.products(Stream.of(products).map(c -> (Product)((Product.Builder)Product.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProducts(Collection<Product.BuilderImpl> products) {
            this.products = ProductsListCopier.copyFromBuilder(products);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeProductsResponse build() {
            return new DescribeProductsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProductsResponse> {
        public Builder products(Collection<Product> var1);

        public Builder products(Product ... var1);

        public Builder products(Consumer<Product.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

