/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;

public class DescribeStandardsControlsIterable
implements SdkIterable<DescribeStandardsControlsResponse> {
    private final SecurityHubClient client;
    private final DescribeStandardsControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeStandardsControlsIterable(SecurityHubClient client, DescribeStandardsControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStandardsControlsResponseFetcher();
    }

    public Iterator<DescribeStandardsControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeStandardsControlsResponseFetcher
    implements SyncPageFetcher<DescribeStandardsControlsResponse> {
        private DescribeStandardsControlsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStandardsControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeStandardsControlsResponse nextPage(DescribeStandardsControlsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStandardsControlsIterable.this.client.describeStandardsControls(DescribeStandardsControlsIterable.this.firstRequest);
            }
            return DescribeStandardsControlsIterable.this.client.describeStandardsControls((DescribeStandardsControlsRequest)((Object)DescribeStandardsControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

