/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;

public class GetInsightsIterable
implements SdkIterable<GetInsightsResponse> {
    private final SecurityHubClient client;
    private final GetInsightsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInsightsIterable(SecurityHubClient client, GetInsightsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetInsightsResponseFetcher();
    }

    public Iterator<GetInsightsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetInsightsResponseFetcher
    implements SyncPageFetcher<GetInsightsResponse> {
        private GetInsightsResponseFetcher() {
        }

        public boolean hasNextPage(GetInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInsightsResponse nextPage(GetInsightsResponse previousPage) {
            if (previousPage == null) {
                return GetInsightsIterable.this.client.getInsights(GetInsightsIterable.this.firstRequest);
            }
            return GetInsightsIterable.this.client.getInsights((GetInsightsRequest)((Object)GetInsightsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

