/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRolesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceEndpoint;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbInstanceDetails> {
    private static final SdkField<List<AwsRdsDbInstanceAssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::associatedRoles)).setter(AwsRdsDbInstanceDetails.setter(Builder::associatedRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbInstanceAssociatedRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::caCertificateIdentifier)).setter(AwsRdsDbInstanceDetails.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::dbClusterIdentifier)).setter(AwsRdsDbInstanceDetails.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::dbInstanceIdentifier)).setter(AwsRdsDbInstanceDetails.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::dbInstanceClass)).setter(AwsRdsDbInstanceDetails.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<Integer> DB_INSTANCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::dbInstancePort)).setter(AwsRdsDbInstanceDetails.setter(Builder::dbInstancePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstancePort").build()}).build();
    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::dbiResourceId)).setter(AwsRdsDbInstanceDetails.setter(Builder::dbiResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::dbName)).setter(AwsRdsDbInstanceDetails.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::deletionProtection)).setter(AwsRdsDbInstanceDetails.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<AwsRdsDbInstanceEndpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::endpoint)).setter(AwsRdsDbInstanceDetails.setter(Builder::endpoint)).constructor(AwsRdsDbInstanceEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::engine)).setter(AwsRdsDbInstanceDetails.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::engineVersion)).setter(AwsRdsDbInstanceDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::iamDatabaseAuthenticationEnabled)).setter(AwsRdsDbInstanceDetails.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<String> INSTANCE_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::instanceCreateTime)).setter(AwsRdsDbInstanceDetails.setter(Builder::instanceCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::kmsKeyId)).setter(AwsRdsDbInstanceDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::publiclyAccessible)).setter(AwsRdsDbInstanceDetails.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::storageEncrypted)).setter(AwsRdsDbInstanceDetails.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::tdeCredentialArn)).setter(AwsRdsDbInstanceDetails.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<List<AwsRdsDbInstanceVpcSecurityGroup>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AwsRdsDbInstanceDetails.getter(AwsRdsDbInstanceDetails::vpcSecurityGroups)).setter(AwsRdsDbInstanceDetails.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbInstanceVpcSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ROLES_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD, DB_INSTANCE_PORT_FIELD, DBI_RESOURCE_ID_FIELD, DB_NAME_FIELD, DELETION_PROTECTION_FIELD, ENDPOINT_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, INSTANCE_CREATE_TIME_FIELD, KMS_KEY_ID_FIELD, PUBLICLY_ACCESSIBLE_FIELD, STORAGE_ENCRYPTED_FIELD, TDE_CREDENTIAL_ARN_FIELD, VPC_SECURITY_GROUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AwsRdsDbInstanceAssociatedRole> associatedRoles;
    private final String caCertificateIdentifier;
    private final String dbClusterIdentifier;
    private final String dbInstanceIdentifier;
    private final String dbInstanceClass;
    private final Integer dbInstancePort;
    private final String dbiResourceId;
    private final String dbName;
    private final Boolean deletionProtection;
    private final AwsRdsDbInstanceEndpoint endpoint;
    private final String engine;
    private final String engineVersion;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final String instanceCreateTime;
    private final String kmsKeyId;
    private final Boolean publiclyAccessible;
    private final Boolean storageEncrypted;
    private final String tdeCredentialArn;
    private final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups;

    private AwsRdsDbInstanceDetails(BuilderImpl builder) {
        this.associatedRoles = builder.associatedRoles;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbInstancePort = builder.dbInstancePort;
        this.dbiResourceId = builder.dbiResourceId;
        this.dbName = builder.dbName;
        this.deletionProtection = builder.deletionProtection;
        this.endpoint = builder.endpoint;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.storageEncrypted = builder.storageEncrypted;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
    }

    public boolean hasAssociatedRoles() {
        return this.associatedRoles != null && !(this.associatedRoles instanceof SdkAutoConstructList);
    }

    public List<AwsRdsDbInstanceAssociatedRole> associatedRoles() {
        return this.associatedRoles;
    }

    public String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public Integer dbInstancePort() {
        return this.dbInstancePort;
    }

    public String dbiResourceId() {
        return this.dbiResourceId;
    }

    public String dbName() {
        return this.dbName;
    }

    public Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public AwsRdsDbInstanceEndpoint endpoint() {
        return this.endpoint;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public String instanceCreateTime() {
        return this.instanceCreateTime;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedRoles());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstancePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbInstanceDetails)) {
            return false;
        }
        AwsRdsDbInstanceDetails other = (AwsRdsDbInstanceDetails)obj;
        return Objects.equals(this.associatedRoles(), other.associatedRoles()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.dbInstancePort(), other.dbInstancePort()) && Objects.equals(this.dbiResourceId(), other.dbiResourceId()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.instanceCreateTime(), other.instanceCreateTime()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups());
    }

    public String toString() {
        return ToString.builder((String)"AwsRdsDbInstanceDetails").add("AssociatedRoles", this.associatedRoles()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("DbInstancePort", (Object)this.dbInstancePort()).add("DbiResourceId", (Object)this.dbiResourceId()).add("DBName", (Object)this.dbName()).add("DeletionProtection", (Object)this.deletionProtection()).add("Endpoint", (Object)this.endpoint()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("IAMDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("InstanceCreateTime", (Object)this.instanceCreateTime()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("VpcSecurityGroups", this.vpcSecurityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatedRoles": {
                return Optional.ofNullable(clazz.cast(this.associatedRoles()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "DbInstancePort": {
                return Optional.ofNullable(clazz.cast(this.dbInstancePort()));
            }
            case "DbiResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbiResourceId()));
            }
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "IAMDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "InstanceCreateTime": {
                return Optional.ofNullable(clazz.cast(this.instanceCreateTime()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbInstanceDetails, T> g) {
        return obj -> g.apply((AwsRdsDbInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsRdsDbInstanceAssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();
        private String caCertificateIdentifier;
        private String dbClusterIdentifier;
        private String dbInstanceIdentifier;
        private String dbInstanceClass;
        private Integer dbInstancePort;
        private String dbiResourceId;
        private String dbName;
        private Boolean deletionProtection;
        private AwsRdsDbInstanceEndpoint endpoint;
        private String engine;
        private String engineVersion;
        private Boolean iamDatabaseAuthenticationEnabled;
        private String instanceCreateTime;
        private String kmsKeyId;
        private Boolean publiclyAccessible;
        private Boolean storageEncrypted;
        private String tdeCredentialArn;
        private List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbInstanceDetails model) {
            this.associatedRoles(model.associatedRoles);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.dbInstanceClass(model.dbInstanceClass);
            this.dbInstancePort(model.dbInstancePort);
            this.dbiResourceId(model.dbiResourceId);
            this.dbName(model.dbName);
            this.deletionProtection(model.deletionProtection);
            this.endpoint(model.endpoint);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.instanceCreateTime(model.instanceCreateTime);
            this.kmsKeyId(model.kmsKeyId);
            this.publiclyAccessible(model.publiclyAccessible);
            this.storageEncrypted(model.storageEncrypted);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
        }

        public final Collection<AwsRdsDbInstanceAssociatedRole.Builder> getAssociatedRoles() {
            return this.associatedRoles != null ? (Collection)this.associatedRoles.stream().map(AwsRdsDbInstanceAssociatedRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associatedRoles(Collection<AwsRdsDbInstanceAssociatedRole> associatedRoles) {
            this.associatedRoles = AwsRdsDbInstanceAssociatedRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AwsRdsDbInstanceAssociatedRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AwsRdsDbInstanceAssociatedRole.Builder> ... associatedRoles) {
            this.associatedRoles(Stream.of(associatedRoles).map(c -> (AwsRdsDbInstanceAssociatedRole)((AwsRdsDbInstanceAssociatedRole.Builder)AwsRdsDbInstanceAssociatedRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAssociatedRoles(Collection<AwsRdsDbInstanceAssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AwsRdsDbInstanceAssociatedRolesCopier.copyFromBuilder(associatedRoles);
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getDbInstancePort() {
            return this.dbInstancePort;
        }

        @Override
        public final Builder dbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
            return this;
        }

        public final void setDbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
        }

        public final String getDbiResourceId() {
            return this.dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        public final String getDbName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        public final AwsRdsDbInstanceEndpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(AwsRdsDbInstanceEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(AwsRdsDbInstanceEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final String getInstanceCreateTime() {
            return this.instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final void setInstanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        public final Collection<AwsRdsDbInstanceVpcSecurityGroup.Builder> getVpcSecurityGroups() {
            return this.vpcSecurityGroups != null ? (Collection)this.vpcSecurityGroups.stream().map(AwsRdsDbInstanceVpcSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (AwsRdsDbInstanceVpcSecurityGroup)((AwsRdsDbInstanceVpcSecurityGroup.Builder)AwsRdsDbInstanceVpcSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public AwsRdsDbInstanceDetails build() {
            return new AwsRdsDbInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbInstanceDetails> {
        public Builder associatedRoles(Collection<AwsRdsDbInstanceAssociatedRole> var1);

        public Builder associatedRoles(AwsRdsDbInstanceAssociatedRole ... var1);

        public Builder associatedRoles(Consumer<AwsRdsDbInstanceAssociatedRole.Builder> ... var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder dbInstancePort(Integer var1);

        public Builder dbiResourceId(String var1);

        public Builder dbName(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder endpoint(AwsRdsDbInstanceEndpoint var1);

        default public Builder endpoint(Consumer<AwsRdsDbInstanceEndpoint.Builder> endpoint) {
            return this.endpoint((AwsRdsDbInstanceEndpoint)((AwsRdsDbInstanceEndpoint.Builder)AwsRdsDbInstanceEndpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder instanceCreateTime(String var1);

        public Builder kmsKeyId(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder tdeCredentialArn(String var1);

        public Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> var1);

        public Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup ... var1);

        public Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder> ... var1);
    }
}

