/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeyStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsIamAccessKeyDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsIamAccessKeyDetails> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::userName)).setter(AwsIamAccessKeyDetails.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::statusAsString)).setter(AwsIamAccessKeyDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::createdAt)).setter(AwsIamAccessKeyDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::principalId)).setter(AwsIamAccessKeyDetails.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::principalType)).setter(AwsIamAccessKeyDetails.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final SdkField<String> PRINCIPAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsIamAccessKeyDetails.getter(AwsIamAccessKeyDetails::principalName)).setter(AwsIamAccessKeyDetails.setter(Builder::principalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, STATUS_FIELD, CREATED_AT_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String status;
    private final String createdAt;
    private final String principalId;
    private final String principalType;
    private final String principalName;

    private AwsIamAccessKeyDetails(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.principalName = builder.principalName;
    }

    public String userName() {
        return this.userName;
    }

    public AwsIamAccessKeyStatus status() {
        return AwsIamAccessKeyStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String createdAt() {
        return this.createdAt;
    }

    public String principalId() {
        return this.principalId;
    }

    public String principalType() {
        return this.principalType;
    }

    public String principalName() {
        return this.principalName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalType());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamAccessKeyDetails)) {
            return false;
        }
        AwsIamAccessKeyDetails other = (AwsIamAccessKeyDetails)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalType(), other.principalType()) && Objects.equals(this.principalName(), other.principalName());
    }

    public String toString() {
        return ToString.builder((String)"AwsIamAccessKeyDetails").add("UserName", (Object)this.userName()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalType()).add("PrincipalName", (Object)this.principalName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalType()));
            }
            case "PrincipalName": {
                return Optional.ofNullable(clazz.cast(this.principalName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamAccessKeyDetails, T> g) {
        return obj -> g.apply((AwsIamAccessKeyDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String status;
        private String createdAt;
        private String principalId;
        private String principalType;
        private String principalName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamAccessKeyDetails model) {
            this.userName(model.userName);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
            this.principalName(model.principalName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AwsIamAccessKeyStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        public final String getPrincipalName() {
            return this.principalName;
        }

        @Override
        public final Builder principalName(String principalName) {
            this.principalName = principalName;
            return this;
        }

        public final void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        public AwsIamAccessKeyDetails build() {
            return new AwsIamAccessKeyDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsIamAccessKeyDetails> {
        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder status(AwsIamAccessKeyStatus var1);

        public Builder createdAt(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalName(String var1);
    }
}

