/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.services.securityhub.model.Partition;
import software.amazon.awssdk.services.securityhub.model.ResourceDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Resource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resource.getter(Resource::type)).setter(Resource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resource.getter(Resource::id)).setter(Resource.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> PARTITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resource.getter(Resource::partitionAsString)).setter(Resource.setter(Builder::partition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Partition").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Resource.getter(Resource::region)).setter(Resource.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Resource.getter(Resource::tags)).setter(Resource.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ResourceDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Resource.getter(Resource::details)).setter(Resource.setter(Builder::details)).constructor(ResourceDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD, PARTITION_FIELD, REGION_FIELD, TAGS_FIELD, DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String id;
    private final String partition;
    private final String region;
    private final Map<String, String> tags;
    private final ResourceDetails details;

    private Resource(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.partition = builder.partition;
        this.region = builder.region;
        this.tags = builder.tags;
        this.details = builder.details;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public Partition partition() {
        return Partition.fromValue(this.partition);
    }

    public String partitionAsString() {
        return this.partition;
    }

    public String region() {
        return this.region;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ResourceDetails details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.partitionAsString(), other.partitionAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"Resource").add("Type", (Object)this.type()).add("Id", (Object)this.id()).add("Partition", (Object)this.partitionAsString()).add("Region", (Object)this.region()).add("Tags", this.tags()).add("Details", (Object)this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Partition": {
                return Optional.ofNullable(clazz.cast(this.partitionAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resource, T> g) {
        return obj -> g.apply((Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String id;
        private String partition;
        private String region;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ResourceDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(Resource model) {
            this.type(model.type);
            this.id(model.id);
            this.partition(model.partition);
            this.region(model.region);
            this.tags(model.tags);
            this.details(model.details);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPartitionAsString() {
            return this.partition;
        }

        @Override
        public final Builder partition(String partition) {
            this.partition = partition;
            return this;
        }

        @Override
        public final Builder partition(Partition partition) {
            this.partition(partition == null ? null : partition.toString());
            return this;
        }

        public final void setPartition(String partition) {
            this.partition = partition;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = FieldMapCopier.copy(tags);
        }

        public final ResourceDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        @Override
        public final Builder details(ResourceDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(ResourceDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        public Resource build() {
            return new Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Resource> {
        public Builder type(String var1);

        public Builder id(String var1);

        public Builder partition(String var1);

        public Builder partition(Partition var1);

        public Builder region(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder details(ResourceDetails var1);

        default public Builder details(Consumer<ResourceDetails.Builder> details) {
            return this.details((ResourceDetails)((ResourceDetails.Builder)ResourceDetails.builder().applyMutation(details)).build());
        }
    }
}

