/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.AccessDeniedException;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.CreateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.CreateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.CreateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.CreateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeHubRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeHubResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMembersRequest;
import software.amazon.awssdk.services.securityhub.model.GetMembersResponse;
import software.amazon.awssdk.services.securityhub.model.InternalException;
import software.amazon.awssdk.services.securityhub.model.InvalidAccessException;
import software.amazon.awssdk.services.securityhub.model.InvalidInputException;
import software.amazon.awssdk.services.securityhub.model.InviteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.InviteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.LimitExceededException;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListMembersRequest;
import software.amazon.awssdk.services.securityhub.model.ListMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityhub.model.ResourceConflictException;
import software.amazon.awssdk.services.securityhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securityhub.model.SecurityHubException;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.TagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.TagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlResponse;
import software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable;
import software.amazon.awssdk.services.securityhub.transform.AcceptInvitationRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.BatchDisableStandardsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.BatchEnableStandardsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.BatchImportFindingsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.BatchUpdateFindingsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.CreateActionTargetRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.CreateInsightRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.CreateMembersRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DeclineInvitationsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DeleteActionTargetRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DeleteInsightRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DeleteInvitationsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DeleteMembersRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DescribeActionTargetsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DescribeHubRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DescribeProductsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DescribeStandardsControlsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DescribeStandardsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DisableImportFindingsForProductRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DisableSecurityHubRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DisassociateFromMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.DisassociateMembersRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.EnableImportFindingsForProductRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.EnableSecurityHubRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetEnabledStandardsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetFindingsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetInsightResultsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetInsightsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetInvitationsCountRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetMasterAccountRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.GetMembersRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.InviteMembersRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.ListEnabledProductsForImportRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.ListInvitationsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.ListMembersRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.UpdateActionTargetRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.UpdateFindingsRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.UpdateInsightRequestMarshaller;
import software.amazon.awssdk.services.securityhub.transform.UpdateStandardsControlRequestMarshaller;

@SdkInternalApi
final class DefaultSecurityHubClient
implements SecurityHubClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSecurityHubClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "securityhub";
    }

    @Override
    public AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AcceptInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptInvitationRequest).withMarshaller((Marshaller)new AcceptInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchDisableStandardsResponse batchDisableStandards(BatchDisableStandardsRequest batchDisableStandardsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDisableStandardsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchDisableStandardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDisableStandards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchDisableStandardsRequest).withMarshaller((Marshaller)new BatchDisableStandardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchEnableStandardsResponse batchEnableStandards(BatchEnableStandardsRequest batchEnableStandardsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchEnableStandardsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchEnableStandardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchEnableStandards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchEnableStandardsRequest).withMarshaller((Marshaller)new BatchEnableStandardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchImportFindingsResponse batchImportFindings(BatchImportFindingsRequest batchImportFindingsRequest) throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchImportFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchImportFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchImportFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchImportFindingsRequest).withMarshaller((Marshaller)new BatchImportFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public BatchUpdateFindingsResponse batchUpdateFindings(BatchUpdateFindingsRequest batchUpdateFindingsRequest) throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (BatchUpdateFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)batchUpdateFindingsRequest).withMarshaller((Marshaller)new BatchUpdateFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateActionTargetResponse createActionTarget(CreateActionTargetRequest createActionTargetRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateActionTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateActionTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateActionTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createActionTargetRequest).withMarshaller((Marshaller)new CreateActionTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateInsightResponse createInsight(CreateInsightRequest createInsightRequest) throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInsightResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInsight").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createInsightRequest).withMarshaller((Marshaller)new CreateInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMembersRequest).withMarshaller((Marshaller)new CreateMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeclineInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeclineInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeclineInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)declineInvitationsRequest).withMarshaller((Marshaller)new DeclineInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteActionTargetResponse deleteActionTarget(DeleteActionTargetRequest deleteActionTargetRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteActionTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteActionTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteActionTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteActionTargetRequest).withMarshaller((Marshaller)new DeleteActionTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteInsightResponse deleteInsight(DeleteInsightRequest deleteInsightRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInsightResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInsight").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInsightRequest).withMarshaller((Marshaller)new DeleteInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest) throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteInvitationsRequest).withMarshaller((Marshaller)new DeleteInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteMembersRequest).withMarshaller((Marshaller)new DeleteMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeActionTargetsResponse describeActionTargets(DescribeActionTargetsRequest describeActionTargetsRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActionTargetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeActionTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActionTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeActionTargetsRequest).withMarshaller((Marshaller)new DescribeActionTargetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeActionTargetsIterable describeActionTargetsPaginator(DescribeActionTargetsRequest describeActionTargetsRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeActionTargetsIterable(this, this.applyPaginatorUserAgent(describeActionTargetsRequest));
    }

    @Override
    public DescribeHubResponse describeHub(DescribeHubRequest describeHubRequest) throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHubResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeHubResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHub").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHubRequest).withMarshaller((Marshaller)new DescribeHubRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProductsResponse describeProducts(DescribeProductsRequest describeProductsRequest) throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeProductsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeProductsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeProducts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeProductsRequest).withMarshaller((Marshaller)new DescribeProductsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeProductsIterable describeProductsPaginator(DescribeProductsRequest describeProductsRequest) throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeProductsIterable(this, this.applyPaginatorUserAgent(describeProductsRequest));
    }

    @Override
    public DescribeStandardsResponse describeStandards(DescribeStandardsRequest describeStandardsRequest) throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStandardsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeStandardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStandards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStandardsRequest).withMarshaller((Marshaller)new DescribeStandardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeStandardsIterable describeStandardsPaginator(DescribeStandardsRequest describeStandardsRequest) throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeStandardsIterable(this, this.applyPaginatorUserAgent(describeStandardsRequest));
    }

    @Override
    public DescribeStandardsControlsResponse describeStandardsControls(DescribeStandardsControlsRequest describeStandardsControlsRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStandardsControlsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeStandardsControlsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStandardsControls").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeStandardsControlsRequest).withMarshaller((Marshaller)new DescribeStandardsControlsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeStandardsControlsIterable describeStandardsControlsPaginator(DescribeStandardsControlsRequest describeStandardsControlsRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeStandardsControlsIterable(this, this.applyPaginatorUserAgent(describeStandardsControlsRequest));
    }

    @Override
    public DisableImportFindingsForProductResponse disableImportFindingsForProduct(DisableImportFindingsForProductRequest disableImportFindingsForProductRequest) throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableImportFindingsForProductResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableImportFindingsForProductResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableImportFindingsForProduct").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableImportFindingsForProductRequest).withMarshaller((Marshaller)new DisableImportFindingsForProductRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableSecurityHubResponse disableSecurityHub(DisableSecurityHubRequest disableSecurityHubRequest) throws InternalException, LimitExceededException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableSecurityHubResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableSecurityHubResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableSecurityHub").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableSecurityHubRequest).withMarshaller((Marshaller)new DisableSecurityHubRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateFromMasterAccountResponse disassociateFromMasterAccount(DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateFromMasterAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateFromMasterAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateFromMasterAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateFromMasterAccountRequest).withMarshaller((Marshaller)new DisassociateFromMasterAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateMembersResponse disassociateMembers(DisassociateMembersRequest disassociateMembersRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateMembersRequest).withMarshaller((Marshaller)new DisassociateMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableImportFindingsForProductResponse enableImportFindingsForProduct(EnableImportFindingsForProductRequest enableImportFindingsForProductRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceConflictException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableImportFindingsForProductResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableImportFindingsForProductResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableImportFindingsForProduct").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableImportFindingsForProductRequest).withMarshaller((Marshaller)new EnableImportFindingsForProductRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableSecurityHubResponse enableSecurityHub(EnableSecurityHubRequest enableSecurityHubRequest) throws InternalException, LimitExceededException, InvalidAccessException, ResourceConflictException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableSecurityHubResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableSecurityHubResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableSecurityHub").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableSecurityHubRequest).withMarshaller((Marshaller)new EnableSecurityHubRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetEnabledStandardsResponse getEnabledStandards(GetEnabledStandardsRequest getEnabledStandardsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEnabledStandardsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetEnabledStandardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEnabledStandards").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEnabledStandardsRequest).withMarshaller((Marshaller)new GetEnabledStandardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetEnabledStandardsIterable getEnabledStandardsPaginator(GetEnabledStandardsRequest getEnabledStandardsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return new GetEnabledStandardsIterable(this, this.applyPaginatorUserAgent(getEnabledStandardsRequest));
    }

    @Override
    public GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingsRequest).withMarshaller((Marshaller)new GetFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetFindingsIterable getFindingsPaginator(GetFindingsRequest getFindingsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return new GetFindingsIterable(this, this.applyPaginatorUserAgent(getFindingsRequest));
    }

    @Override
    public GetInsightResultsResponse getInsightResults(GetInsightResultsRequest getInsightResultsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightResultsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetInsightResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightResults").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInsightResultsRequest).withMarshaller((Marshaller)new GetInsightResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetInsightsResponse getInsights(GetInsightsRequest getInsightsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetInsightsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsights").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInsightsRequest).withMarshaller((Marshaller)new GetInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetInsightsIterable getInsightsPaginator(GetInsightsRequest getInsightsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return new GetInsightsIterable(this, this.applyPaginatorUserAgent(getInsightsRequest));
    }

    @Override
    public GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInvitationsCountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetInvitationsCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInvitationsCount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getInvitationsCountRequest).withMarshaller((Marshaller)new GetInvitationsCountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMasterAccountResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetMasterAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMasterAccount").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMasterAccountRequest).withMarshaller((Marshaller)new GetMasterAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMembersRequest).withMarshaller((Marshaller)new GetMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public InviteMembersResponse inviteMembers(InviteMembersRequest inviteMembersRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InviteMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (InviteMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InviteMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)inviteMembersRequest).withMarshaller((Marshaller)new InviteMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEnabledProductsForImportResponse listEnabledProductsForImport(ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) throws InternalException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEnabledProductsForImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListEnabledProductsForImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEnabledProductsForImport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listEnabledProductsForImportRequest).withMarshaller((Marshaller)new ListEnabledProductsForImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) throws InternalException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return new ListEnabledProductsForImportIterable(this, this.applyPaginatorUserAgent(listEnabledProductsForImportRequest));
    }

    @Override
    public ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listInvitationsRequest).withMarshaller((Marshaller)new ListInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return new ListInvitationsIterable(this, this.applyPaginatorUserAgent(listInvitationsRequest));
    }

    @Override
    public ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMembersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListMembersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMembers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMembersRequest).withMarshaller((Marshaller)new ListMembersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return new ListMembersIterable(this, this.applyPaginatorUserAgent(listMembersRequest));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateActionTargetResponse updateActionTarget(UpdateActionTargetRequest updateActionTargetRequest) throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateActionTargetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateActionTargetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateActionTarget").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateActionTargetRequest).withMarshaller((Marshaller)new UpdateActionTargetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateFindingsResponse updateFindings(UpdateFindingsRequest updateFindingsRequest) throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFindingsRequest).withMarshaller((Marshaller)new UpdateFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateInsightResponse updateInsight(UpdateInsightRequest updateInsightRequest) throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInsightResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateInsightResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInsight").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateInsightRequest).withMarshaller((Marshaller)new UpdateInsightRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateStandardsControlResponse updateStandardsControl(UpdateStandardsControlRequest updateStandardsControlRequest) throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStandardsControlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateStandardsControlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStandardsControl").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateStandardsControlRequest).withMarshaller((Marshaller)new UpdateStandardsControlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SecurityHubException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAccessException").exceptionBuilderSupplier(InvalidAccessException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceConflictException").exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInputException").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends SecurityHubRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.18").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SecurityHubRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

