/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;

public class ListEnabledProductsForImportIterable
implements SdkIterable<ListEnabledProductsForImportResponse> {
    private final SecurityHubClient client;
    private final ListEnabledProductsForImportRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnabledProductsForImportIterable(SecurityHubClient client, ListEnabledProductsForImportRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnabledProductsForImportResponseFetcher();
    }

    public Iterator<ListEnabledProductsForImportResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEnabledProductsForImportResponseFetcher
    implements SyncPageFetcher<ListEnabledProductsForImportResponse> {
        private ListEnabledProductsForImportResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledProductsForImportResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnabledProductsForImportResponse nextPage(ListEnabledProductsForImportResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledProductsForImportIterable.this.client.listEnabledProductsForImport(ListEnabledProductsForImportIterable.this.firstRequest);
            }
            return ListEnabledProductsForImportIterable.this.client.listEnabledProductsForImport((ListEnabledProductsForImportRequest)((Object)ListEnabledProductsForImportIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

