/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedFinding> {
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelatedFinding.getter(RelatedFinding::productArn)).setter(RelatedFinding.setter(Builder::productArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductArn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RelatedFinding.getter(RelatedFinding::id)).setter(RelatedFinding.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ARN_FIELD, ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productArn;
    private final String id;

    private RelatedFinding(BuilderImpl builder) {
        this.productArn = builder.productArn;
        this.id = builder.id;
    }

    public String productArn() {
        return this.productArn;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedFinding)) {
            return false;
        }
        RelatedFinding other = (RelatedFinding)obj;
        return Objects.equals(this.productArn(), other.productArn()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        return ToString.builder((String)"RelatedFinding").add("ProductArn", (Object)this.productArn()).add("Id", (Object)this.id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductArn": {
                return Optional.ofNullable(clazz.cast(this.productArn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedFinding, T> g) {
        return obj -> g.apply((RelatedFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productArn;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedFinding model) {
            this.productArn(model.productArn);
            this.id(model.id);
        }

        public final String getProductArn() {
            return this.productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public RelatedFinding build() {
            return new RelatedFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedFinding> {
        public Builder productArn(String var1);

        public Builder id(String var1);
    }
}

