/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;

public class GetFindingsPublisher
implements SdkPublisher<GetFindingsResponse> {
    private final SecurityHubAsyncClient client;
    private final GetFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingsPublisher(SecurityHubAsyncClient client, GetFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingsPublisher(SecurityHubAsyncClient client, GetFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetFindingsPublisher resume(GetFindingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetFindingsPublisher(this.client, (GetFindingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetFindingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetFindingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetFindingsResponseFetcher
    implements AsyncPageFetcher<GetFindingsResponse> {
        private GetFindingsResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingsResponse> nextPage(GetFindingsResponse previousPage) {
            if (previousPage == null) {
                return GetFindingsPublisher.this.client.getFindings(GetFindingsPublisher.this.firstRequest);
            }
            return GetFindingsPublisher.this.client.getFindings((GetFindingsRequest)((Object)GetFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

