/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SortByType {
    CREATED_DATE("created-date"),
    LAST_ACCESSED_DATE("last-accessed-date"),
    LAST_CHANGED_DATE("last-changed-date"),
    NAME("name"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SortByType> VALUE_MAP;
    private final String value;

    private SortByType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SortByType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SortByType> knownValues() {
        EnumSet<SortByType> knownValues = EnumSet.allOf(SortByType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SortByType.class, SortByType::toString);
    }
}

