/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecretRequest extends SecretsManagerRequest implements
        ToCopyableBuilder<UpdateSecretRequest.Builder, UpdateSecretRequest> {
    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretId").getter(getter(UpdateSecretRequest::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(UpdateSecretRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateSecretRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(UpdateSecretRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<SdkBytes> SECRET_BINARY_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("SecretBinary").getter(getter(UpdateSecretRequest::secretBinary)).setter(setter(Builder::secretBinary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretBinary").build()).build();

    private static final SdkField<String> SECRET_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretString").getter(getter(UpdateSecretRequest::secretString)).setter(setter(Builder::secretString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretString").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateSecretRequest::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SECRET_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, DESCRIPTION_FIELD, KMS_KEY_ID_FIELD, SECRET_BINARY_FIELD,
                    SECRET_STRING_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String secretId;

    private final String clientRequestToken;

    private final String description;

    private final String kmsKeyId;

    private final SdkBytes secretBinary;

    private final String secretString;

    private final String type;

    private UpdateSecretRequest(BuilderImpl builder) {
        super(builder);
        this.secretId = builder.secretId;
        this.clientRequestToken = builder.clientRequestToken;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.secretBinary = builder.secretBinary;
        this.secretString = builder.secretString;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN or name of the secret.
     * </p>
     * <p>
     * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen">Finding
     * a secret from a partial ARN</a>.
     * </p>
     * 
     * @return The ARN or name of the secret.</p>
     *         <p>
     *         For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
     *         "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
     *         >Finding a secret from a partial ARN</a>.
     */
    public final String secretId() {
        return secretId;
    }

    /**
     * <p>
     * If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new version
     * for the secret, and this parameter specifies the unique identifier for the new version.
     * </p>
     * <note>
     * <p>
     * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then you
     * can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the value for
     * this parameter in the request.
     * </p>
     * </note>
     * <p>
     * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
     * <code>ClientRequestToken</code> and include it in the request.
     * </p>
     * <p>
     * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of
     * duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a
     * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of your
     * versions within the specified secret.
     * </p>
     * 
     * @return If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new
     *         version for the secret, and this parameter specifies the unique identifier for the new version.</p>
     *         <note>
     *         <p>
     *         If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation,
     *         then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it
     *         as the value for this parameter in the request.
     *         </p>
     *         </note>
     *         <p>
     *         If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
     *         <code>ClientRequestToken</code> and include it in the request.
     *         </p>
     *         <p>
     *         This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation
     *         of duplicate versions if there are failures and retries during a rotation. We recommend that you generate
     *         a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure
     *         uniqueness of your versions within the specified secret.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The description of the secret.
     * </p>
     * 
     * @return The description of the secret.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as any
     * existing versions with the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or
     * <code>AWSPREVIOUS</code>. If you don't have <code>kms:Encrypt</code> permission to the new key, Secrets Manager
     * does not re-encrypt existing secret versions with the new key. For more information about versions and staging
     * labels, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version">Concepts:
     * Version</a>.
     * </p>
     * <p>
     * A key alias is always prefixed by <code>alias/</code>, for example <code>alias/aws/secretsmanager</code>. For
     * more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html">About
     * aliases</a>.
     * </p>
     * <p>
     * If you set this to an empty string, Secrets Manager uses the Amazon Web Services managed key
     * <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager creates
     * it for you automatically. All users and roles in the Amazon Web Services account automatically have access to use
     * <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a one-time significant
     * delay in returning the result.
     * </p>
     * <important>
     * <p>
     * You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this operation
     * using credentials from the same Amazon Web Services account that owns the secret. If the secret is in a different
     * account, then you must use a customer managed key and provide the ARN of that KMS key in this field. The user
     * making the call must have permissions to both the secret and the KMS key in their respective accounts.
     * </p>
     * </important>
     * 
     * @return The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well
     *         as any existing versions with the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or
     *         <code>AWSPREVIOUS</code>. If you don't have <code>kms:Encrypt</code> permission to the new key, Secrets
     *         Manager does not re-encrypt existing secret versions with the new key. For more information about
     *         versions and staging labels, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version"
     *         >Concepts: Version</a>.</p>
     *         <p>
     *         A key alias is always prefixed by <code>alias/</code>, for example <code>alias/aws/secretsmanager</code>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html">About aliases</a>.
     *         </p>
     *         <p>
     *         If you set this to an empty string, Secrets Manager uses the Amazon Web Services managed key
     *         <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager
     *         creates it for you automatically. All users and roles in the Amazon Web Services account automatically
     *         have access to use <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result
     *         in a one-time significant delay in returning the result.
     *         </p>
     *         <important>
     *         <p>
     *         You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this
     *         operation using credentials from the same Amazon Web Services account that owns the secret. If the secret
     *         is in a different account, then you must use a customer managed key and provide the ARN of that KMS key
     *         in this field. The user making the call must have permissions to both the secret and the KMS key in their
     *         respective accounts.
     *         </p>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The binary data to encrypt and store in the new version of the secret. We recommend that you store your binary
     * data in a file and then pass the contents of the file as a parameter.
     * </p>
     * <p>
     * Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
     * </p>
     * <p>
     * You can't access this parameter in the Secrets Manager console.
     * </p>
     * <p>
     * Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail log
     * entries. If you create your own log entries, you must also avoid logging the information in this field.
     * </p>
     * 
     * @return The binary data to encrypt and store in the new version of the secret. We recommend that you store your
     *         binary data in a file and then pass the contents of the file as a parameter. </p>
     *         <p>
     *         Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
     *         </p>
     *         <p>
     *         You can't access this parameter in the Secrets Manager console.
     *         </p>
     *         <p>
     *         Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail
     *         log entries. If you create your own log entries, you must also avoid logging the information in this
     *         field.
     */
    public final SdkBytes secretBinary() {
        return secretBinary;
    }

    /**
     * <p>
     * The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of
     * key/value pairs for your secret value.
     * </p>
     * <p>
     * Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
     * </p>
     * <p>
     * Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail log
     * entries. If you create your own log entries, you must also avoid logging the information in this field.
     * </p>
     * 
     * @return The text data to encrypt and store in the new version of the secret. We recommend you use a JSON
     *         structure of key/value pairs for your secret value. </p>
     *         <p>
     *         Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
     *         </p>
     *         <p>
     *         Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail
     *         log entries. If you create your own log entries, you must also avoid logging the information in this
     *         field.
     */
    public final String secretString() {
        return secretString;
    }

    /**
     * <p>
     * The exact string that identifies the third-party partner that holds the external secret. For more information,
     * see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-partners.html">Managed external
     * secret partners</a>.
     * </p>
     * 
     * @return The exact string that identifies the third-party partner that holds the external secret. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-partners.html">Managed external
     *         secret partners</a>.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(secretBinary());
        hashCode = 31 * hashCode + Objects.hashCode(secretString());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecretRequest)) {
            return false;
        }
        UpdateSecretRequest other = (UpdateSecretRequest) obj;
        return Objects.equals(secretId(), other.secretId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(description(), other.description()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(secretBinary(), other.secretBinary()) && Objects.equals(secretString(), other.secretString())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecretRequest").add("SecretId", secretId())
                .add("ClientRequestToken", clientRequestToken()).add("Description", description()).add("KmsKeyId", kmsKeyId())
                .add("SecretBinary", secretBinary() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SecretString", secretString() == null ? null : "*** Sensitive Data Redacted ***").add("Type", type())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "SecretBinary":
            return Optional.ofNullable(clazz.cast(secretBinary()));
        case "SecretString":
            return Optional.ofNullable(clazz.cast(secretString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretId", SECRET_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("SecretBinary", SECRET_BINARY_FIELD);
        map.put("SecretString", SECRET_STRING_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecretRequest, T> g) {
        return obj -> g.apply((UpdateSecretRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecretsManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecretRequest> {
        /**
         * <p>
         * The ARN or name of the secret.
         * </p>
         * <p>
         * For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         * >Finding a secret from a partial ARN</a>.
         * </p>
         * 
         * @param secretId
         *        The ARN or name of the secret.</p>
         *        <p>
         *        For an ARN, we recommend that you specify a complete ARN rather than a partial ARN. See <a href=
         *        "https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen"
         *        >Finding a secret from a partial ARN</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);

        /**
         * <p>
         * If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a new
         * version for the secret, and this parameter specifies the unique identifier for the new version.
         * </p>
         * <note>
         * <p>
         * If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation, then
         * you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes it as the
         * value for this parameter in the request.
         * </p>
         * </note>
         * <p>
         * If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
         * <code>ClientRequestToken</code> and include it in the request.
         * </p>
         * <p>
         * This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental creation of
         * duplicate versions if there are failures and retries during a rotation. We recommend that you generate a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value to ensure uniqueness of
         * your versions within the specified secret.
         * </p>
         * 
         * @param clientRequestToken
         *        If you include <code>SecretString</code> or <code>SecretBinary</code>, then Secrets Manager creates a
         *        new version for the secret, and this parameter specifies the unique identifier for the new
         *        version.</p> <note>
         *        <p>
         *        If you use the Amazon Web Services CLI or one of the Amazon Web Services SDKs to call this operation,
         *        then you can leave this parameter empty. The CLI or SDK generates a random UUID for you and includes
         *        it as the value for this parameter in the request.
         *        </p>
         *        </note>
         *        <p>
         *        If you generate a raw HTTP request to the Secrets Manager service endpoint, then you must generate a
         *        <code>ClientRequestToken</code> and include it in the request.
         *        </p>
         *        <p>
         *        This value helps ensure idempotency. Secrets Manager uses this value to prevent the accidental
         *        creation of duplicate versions if there are failures and retries during a rotation. We recommend that
         *        you generate a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID-type</a> value
         *        to ensure uniqueness of your versions within the specified secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The description of the secret.
         * </p>
         * 
         * @param description
         *        The description of the secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as well as
         * any existing versions with the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>, or
         * <code>AWSPREVIOUS</code>. If you don't have <code>kms:Encrypt</code> permission to the new key, Secrets
         * Manager does not re-encrypt existing secret versions with the new key. For more information about versions
         * and staging labels, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version"
         * >Concepts: Version</a>.
         * </p>
         * <p>
         * A key alias is always prefixed by <code>alias/</code>, for example <code>alias/aws/secretsmanager</code>. For
         * more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html">About
         * aliases</a>.
         * </p>
         * <p>
         * If you set this to an empty string, Secrets Manager uses the Amazon Web Services managed key
         * <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets Manager
         * creates it for you automatically. All users and roles in the Amazon Web Services account automatically have
         * access to use <code>aws/secretsmanager</code>. Creating <code>aws/secretsmanager</code> can result in a
         * one-time significant delay in returning the result.
         * </p>
         * <important>
         * <p>
         * You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this
         * operation using credentials from the same Amazon Web Services account that owns the secret. If the secret is
         * in a different account, then you must use a customer managed key and provide the ARN of that KMS key in this
         * field. The user making the call must have permissions to both the secret and the KMS key in their respective
         * accounts.
         * </p>
         * </important>
         * 
         * @param kmsKeyId
         *        The ARN, key ID, or alias of the KMS key that Secrets Manager uses to encrypt new secret versions as
         *        well as any existing versions with the staging labels <code>AWSCURRENT</code>, <code>AWSPENDING</code>
         *        , or <code>AWSPREVIOUS</code>. If you don't have <code>kms:Encrypt</code> permission to the new key,
         *        Secrets Manager does not re-encrypt existing secret versions with the new key. For more information
         *        about versions and staging labels, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version"
         *        >Concepts: Version</a>.</p>
         *        <p>
         *        A key alias is always prefixed by <code>alias/</code>, for example
         *        <code>alias/aws/secretsmanager</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/alias-about.html">About aliases</a>.
         *        </p>
         *        <p>
         *        If you set this to an empty string, Secrets Manager uses the Amazon Web Services managed key
         *        <code>aws/secretsmanager</code>. If this key doesn't already exist in your account, then Secrets
         *        Manager creates it for you automatically. All users and roles in the Amazon Web Services account
         *        automatically have access to use <code>aws/secretsmanager</code>. Creating
         *        <code>aws/secretsmanager</code> can result in a one-time significant delay in returning the result.
         *        </p>
         *        <important>
         *        <p>
         *        You can only use the Amazon Web Services managed key <code>aws/secretsmanager</code> if you call this
         *        operation using credentials from the same Amazon Web Services account that owns the secret. If the
         *        secret is in a different account, then you must use a customer managed key and provide the ARN of that
         *        KMS key in this field. The user making the call must have permissions to both the secret and the KMS
         *        key in their respective accounts.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The binary data to encrypt and store in the new version of the secret. We recommend that you store your
         * binary data in a file and then pass the contents of the file as a parameter.
         * </p>
         * <p>
         * Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
         * </p>
         * <p>
         * You can't access this parameter in the Secrets Manager console.
         * </p>
         * <p>
         * Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail log
         * entries. If you create your own log entries, you must also avoid logging the information in this field.
         * </p>
         * 
         * @param secretBinary
         *        The binary data to encrypt and store in the new version of the secret. We recommend that you store
         *        your binary data in a file and then pass the contents of the file as a parameter. </p>
         *        <p>
         *        Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
         *        </p>
         *        <p>
         *        You can't access this parameter in the Secrets Manager console.
         *        </p>
         *        <p>
         *        Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail
         *        log entries. If you create your own log entries, you must also avoid logging the information in this
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretBinary(SdkBytes secretBinary);

        /**
         * <p>
         * The text data to encrypt and store in the new version of the secret. We recommend you use a JSON structure of
         * key/value pairs for your secret value.
         * </p>
         * <p>
         * Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
         * </p>
         * <p>
         * Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail log
         * entries. If you create your own log entries, you must also avoid logging the information in this field.
         * </p>
         * 
         * @param secretString
         *        The text data to encrypt and store in the new version of the secret. We recommend you use a JSON
         *        structure of key/value pairs for your secret value. </p>
         *        <p>
         *        Either <code>SecretBinary</code> or <code>SecretString</code> must have a value, but not both.
         *        </p>
         *        <p>
         *        Sensitive: This field contains sensitive information, so the service does not include it in CloudTrail
         *        log entries. If you create your own log entries, you must also avoid logging the information in this
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretString(String secretString);

        /**
         * <p>
         * The exact string that identifies the third-party partner that holds the external secret. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-partners.html">Managed external secret
         * partners</a>.
         * </p>
         * 
         * @param type
         *        The exact string that identifies the third-party partner that holds the external secret. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/mes-partners.html">Managed external
         *        secret partners</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecretsManagerRequest.BuilderImpl implements Builder {
        private String secretId;

        private String clientRequestToken;

        private String description;

        private String kmsKeyId;

        private SdkBytes secretBinary;

        private String secretString;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecretRequest model) {
            super(model);
            secretId(model.secretId);
            clientRequestToken(model.clientRequestToken);
            description(model.description);
            kmsKeyId(model.kmsKeyId);
            secretBinary(model.secretBinary);
            secretString(model.secretString);
            type(model.type);
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final ByteBuffer getSecretBinary() {
            return secretBinary == null ? null : secretBinary.asByteBuffer();
        }

        public final void setSecretBinary(ByteBuffer secretBinary) {
            secretBinary(secretBinary == null ? null : SdkBytes.fromByteBuffer(secretBinary));
        }

        @Override
        public final Builder secretBinary(SdkBytes secretBinary) {
            this.secretBinary = secretBinary;
            return this;
        }

        public final String getSecretString() {
            return secretString;
        }

        public final void setSecretString(String secretString) {
            this.secretString = secretString;
        }

        @Override
        public final Builder secretString(String secretString) {
            this.secretString = secretString;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecretRequest build() {
            return new UpdateSecretRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
