/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.BatchGetSecretValueResponse;

public class BatchGetSecretValuePublisher
implements SdkPublisher<BatchGetSecretValueResponse> {
    private final SecretsManagerAsyncClient client;
    private final BatchGetSecretValueRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public BatchGetSecretValuePublisher(SecretsManagerAsyncClient client, BatchGetSecretValueRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private BatchGetSecretValuePublisher(SecretsManagerAsyncClient client, BatchGetSecretValueRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new BatchGetSecretValueResponseFetcher();
    }

    public void subscribe(Subscriber<? super BatchGetSecretValueResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class BatchGetSecretValueResponseFetcher
    implements AsyncPageFetcher<BatchGetSecretValueResponse> {
        private BatchGetSecretValueResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetSecretValueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<BatchGetSecretValueResponse> nextPage(BatchGetSecretValueResponse previousPage) {
            if (previousPage == null) {
                return BatchGetSecretValuePublisher.this.client.batchGetSecretValue(BatchGetSecretValuePublisher.this.firstRequest);
            }
            return BatchGetSecretValuePublisher.this.client.batchGetSecretValue((BatchGetSecretValueRequest)((Object)BatchGetSecretValuePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

