/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.secretsmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom type that specifies a <code>Region</code> and the <code>KmsKeyId</code> for a replica secret.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicaRegionType implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicaRegionType.Builder, ReplicaRegionType> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ReplicaRegionType::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ReplicaRegionType::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REGION_FIELD, KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String kmsKeyId;

    private ReplicaRegionType(BuilderImpl builder) {
        this.region = builder.region;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * A Region code. For a list of Region codes, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Name and code of Regions</a>.
     * </p>
     * 
     * @return A Region code. For a list of Region codes, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Name and code of
     *         Regions</a>.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets Manager
     * uses <code>aws/secretsmanager</code>.
     * </p>
     * 
     * @return The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets
     *         Manager uses <code>aws/secretsmanager</code>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaRegionType)) {
            return false;
        }
        ReplicaRegionType other = (ReplicaRegionType) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicaRegionType").add("Region", region()).add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaRegionType, T> g) {
        return obj -> g.apply((ReplicaRegionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicaRegionType> {
        /**
         * <p>
         * A Region code. For a list of Region codes, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Name and code of
         * Regions</a>.
         * </p>
         * 
         * @param region
         *        A Region code. For a list of Region codes, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints">Name and code of
         *        Regions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets
         * Manager uses <code>aws/secretsmanager</code>.
         * </p>
         * 
         * @param kmsKeyId
         *        The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field,
         *        Secrets Manager uses <code>aws/secretsmanager</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaRegionType model) {
            region(model.region);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public ReplicaRegionType build() {
            return new ReplicaRegionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
