/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.secretsmanager.model.RotateSecretRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RotateSecretRequestModelMarshaller {
    private static final MarshallingInfo<String> SECRETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTREQUESTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> ROTATIONLAMBDAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationLambdaARN").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ROTATIONRULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RotationRules").isBinary(false).build();
    private static final RotateSecretRequestModelMarshaller INSTANCE = new RotateSecretRequestModelMarshaller();

    private RotateSecretRequestModelMarshaller() {
    }

    public static RotateSecretRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RotateSecretRequest rotateSecretRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)rotateSecretRequest), (String)"rotateSecretRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rotateSecretRequest.secretId(), SECRETID_BINDING);
            protocolMarshaller.marshall((Object)rotateSecretRequest.clientRequestToken(), CLIENTREQUESTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)rotateSecretRequest.rotationLambdaARN(), ROTATIONLAMBDAARN_BINDING);
            protocolMarshaller.marshall((Object)rotateSecretRequest.rotationRules(), ROTATIONRULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

