/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.secretsmanager.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.secretsmanager.model.RotationRulesType;
import software.amazon.awssdk.services.secretsmanager.model.SecretVersionsToStagesMapTypeCopier;
import software.amazon.awssdk.services.secretsmanager.model.Tag;
import software.amazon.awssdk.services.secretsmanager.model.TagListTypeCopier;
import software.amazon.awssdk.services.secretsmanager.transform.SecretListEntryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SecretListEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, SecretListEntry> {
    private final String arn;
    private final String name;
    private final String description;
    private final String kmsKeyId;
    private final Boolean rotationEnabled;
    private final String rotationLambdaARN;
    private final RotationRulesType rotationRules;
    private final Instant lastRotatedDate;
    private final Instant lastChangedDate;
    private final Instant lastAccessedDate;
    private final Instant deletedDate;
    private final List<Tag> tags;
    private final Map<String, List<String>> secretVersionsToStages;

    private SecretListEntry(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.kmsKeyId = builder.kmsKeyId;
        this.rotationEnabled = builder.rotationEnabled;
        this.rotationLambdaARN = builder.rotationLambdaARN;
        this.rotationRules = builder.rotationRules;
        this.lastRotatedDate = builder.lastRotatedDate;
        this.lastChangedDate = builder.lastChangedDate;
        this.lastAccessedDate = builder.lastAccessedDate;
        this.deletedDate = builder.deletedDate;
        this.tags = builder.tags;
        this.secretVersionsToStages = builder.secretVersionsToStages;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean rotationEnabled() {
        return this.rotationEnabled;
    }

    public String rotationLambdaARN() {
        return this.rotationLambdaARN;
    }

    public RotationRulesType rotationRules() {
        return this.rotationRules;
    }

    public Instant lastRotatedDate() {
        return this.lastRotatedDate;
    }

    public Instant lastChangedDate() {
        return this.lastChangedDate;
    }

    public Instant lastAccessedDate() {
        return this.lastAccessedDate;
    }

    public Instant deletedDate() {
        return this.deletedDate;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Map<String, List<String>> secretVersionsToStages() {
        return this.secretVersionsToStages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationLambdaARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRotatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastChangedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastAccessedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretVersionsToStages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecretListEntry)) {
            return false;
        }
        SecretListEntry other = (SecretListEntry)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.rotationEnabled(), other.rotationEnabled()) && Objects.equals(this.rotationLambdaARN(), other.rotationLambdaARN()) && Objects.equals(this.rotationRules(), other.rotationRules()) && Objects.equals(this.lastRotatedDate(), other.lastRotatedDate()) && Objects.equals(this.lastChangedDate(), other.lastChangedDate()) && Objects.equals(this.lastAccessedDate(), other.lastAccessedDate()) && Objects.equals(this.deletedDate(), other.deletedDate()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.secretVersionsToStages(), other.secretVersionsToStages());
    }

    public String toString() {
        return ToString.builder((String)"SecretListEntry").add("ARN", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("KmsKeyId", (Object)this.kmsKeyId()).add("RotationEnabled", (Object)this.rotationEnabled()).add("RotationLambdaARN", (Object)this.rotationLambdaARN()).add("RotationRules", (Object)this.rotationRules()).add("LastRotatedDate", (Object)this.lastRotatedDate()).add("LastChangedDate", (Object)this.lastChangedDate()).add("LastAccessedDate", (Object)this.lastAccessedDate()).add("DeletedDate", (Object)this.deletedDate()).add("Tags", this.tags()).add("SecretVersionsToStages", this.secretVersionsToStages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ARN": {
                return Optional.of(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "RotationEnabled": {
                return Optional.of(clazz.cast(this.rotationEnabled()));
            }
            case "RotationLambdaARN": {
                return Optional.of(clazz.cast(this.rotationLambdaARN()));
            }
            case "RotationRules": {
                return Optional.of(clazz.cast(this.rotationRules()));
            }
            case "LastRotatedDate": {
                return Optional.of(clazz.cast(this.lastRotatedDate()));
            }
            case "LastChangedDate": {
                return Optional.of(clazz.cast(this.lastChangedDate()));
            }
            case "LastAccessedDate": {
                return Optional.of(clazz.cast(this.lastAccessedDate()));
            }
            case "DeletedDate": {
                return Optional.of(clazz.cast(this.deletedDate()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "SecretVersionsToStages": {
                return Optional.of(clazz.cast(this.secretVersionsToStages()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SecretListEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String kmsKeyId;
        private Boolean rotationEnabled;
        private String rotationLambdaARN;
        private RotationRulesType rotationRules;
        private Instant lastRotatedDate;
        private Instant lastChangedDate;
        private Instant lastAccessedDate;
        private Instant deletedDate;
        private List<Tag> tags;
        private Map<String, List<String>> secretVersionsToStages;

        private BuilderImpl() {
        }

        private BuilderImpl(SecretListEntry model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.kmsKeyId(model.kmsKeyId);
            this.rotationEnabled(model.rotationEnabled);
            this.rotationLambdaARN(model.rotationLambdaARN);
            this.rotationRules(model.rotationRules);
            this.lastRotatedDate(model.lastRotatedDate);
            this.lastChangedDate(model.lastChangedDate);
            this.lastAccessedDate(model.lastAccessedDate);
            this.deletedDate(model.deletedDate);
            this.tags(model.tags);
            this.secretVersionsToStages(model.secretVersionsToStages);
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getRotationEnabled() {
            return this.rotationEnabled;
        }

        @Override
        public final Builder rotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
            return this;
        }

        public final void setRotationEnabled(Boolean rotationEnabled) {
            this.rotationEnabled = rotationEnabled;
        }

        public final String getRotationLambdaARN() {
            return this.rotationLambdaARN;
        }

        @Override
        public final Builder rotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
            return this;
        }

        public final void setRotationLambdaARN(String rotationLambdaARN) {
            this.rotationLambdaARN = rotationLambdaARN;
        }

        public final RotationRulesType.Builder getRotationRules() {
            return this.rotationRules != null ? this.rotationRules.toBuilder() : null;
        }

        @Override
        public final Builder rotationRules(RotationRulesType rotationRules) {
            this.rotationRules = rotationRules;
            return this;
        }

        public final void setRotationRules(RotationRulesType.BuilderImpl rotationRules) {
            this.rotationRules = rotationRules != null ? rotationRules.build() : null;
        }

        public final Instant getLastRotatedDate() {
            return this.lastRotatedDate;
        }

        @Override
        public final Builder lastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
            return this;
        }

        public final void setLastRotatedDate(Instant lastRotatedDate) {
            this.lastRotatedDate = lastRotatedDate;
        }

        public final Instant getLastChangedDate() {
            return this.lastChangedDate;
        }

        @Override
        public final Builder lastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
            return this;
        }

        public final void setLastChangedDate(Instant lastChangedDate) {
            this.lastChangedDate = lastChangedDate;
        }

        public final Instant getLastAccessedDate() {
            return this.lastAccessedDate;
        }

        @Override
        public final Builder lastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
            return this;
        }

        public final void setLastAccessedDate(Instant lastAccessedDate) {
            this.lastAccessedDate = lastAccessedDate;
        }

        public final Instant getDeletedDate() {
            return this.deletedDate;
        }

        @Override
        public final Builder deletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
            return this;
        }

        public final void setDeletedDate(Instant deletedDate) {
            this.deletedDate = deletedDate;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListTypeCopier.copyFromBuilder(tags);
        }

        public final Map<String, ? extends Collection<String>> getSecretVersionsToStages() {
            return this.secretVersionsToStages;
        }

        @Override
        public final Builder secretVersionsToStages(Map<String, ? extends Collection<String>> secretVersionsToStages) {
            this.secretVersionsToStages = SecretVersionsToStagesMapTypeCopier.copy(secretVersionsToStages);
            return this;
        }

        public final void setSecretVersionsToStages(Map<String, ? extends Collection<String>> secretVersionsToStages) {
            this.secretVersionsToStages = SecretVersionsToStagesMapTypeCopier.copy(secretVersionsToStages);
        }

        public SecretListEntry build() {
            return new SecretListEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SecretListEntry> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder kmsKeyId(String var1);

        public Builder rotationEnabled(Boolean var1);

        public Builder rotationLambdaARN(String var1);

        public Builder rotationRules(RotationRulesType var1);

        default public Builder rotationRules(Consumer<RotationRulesType.Builder> rotationRules) {
            return this.rotationRules((RotationRulesType)((RotationRulesType.Builder)RotationRulesType.builder().apply(rotationRules)).build());
        }

        public Builder lastRotatedDate(Instant var1);

        public Builder lastChangedDate(Instant var1);

        public Builder lastAccessedDate(Instant var1);

        public Builder deletedDate(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder secretVersionsToStages(Map<String, ? extends Collection<String>> var1);
    }
}

