/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.scheduler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The templated target type for the EventBridge <a
 * href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html"> <code>PutEvents</code> </a>
 * API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventBridgeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<EventBridgeParameters.Builder, EventBridgeParameters> {
    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailType").getter(getter(EventBridgeParameters::detailType)).setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(EventBridgeParameters::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAIL_TYPE_FIELD,
            SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detailType;

    private final String source;

    private EventBridgeParameters(BuilderImpl builder) {
        this.detailType = builder.detailType;
        this.source = builder.source;
    }

    /**
     * <p>
     * A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.
     * </p>
     * 
     * @return A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event
     *         detail.
     */
    public final String detailType() {
        return detailType;
    }

    /**
     * <p>
     * The source of the event.
     * </p>
     * 
     * @return The source of the event.
     */
    public final String source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(detailType());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventBridgeParameters)) {
            return false;
        }
        EventBridgeParameters other = (EventBridgeParameters) obj;
        return Objects.equals(detailType(), other.detailType()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventBridgeParameters").add("DetailType", detailType()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailType()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventBridgeParameters, T> g) {
        return obj -> g.apply((EventBridgeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventBridgeParameters> {
        /**
         * <p>
         * A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event
         * detail.
         * </p>
         * 
         * @param detailType
         *        A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the
         *        event detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * The source of the event.
         * </p>
         * 
         * @param source
         *        The source of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);
    }

    static final class BuilderImpl implements Builder {
        private String detailType;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(EventBridgeParameters model) {
            detailType(model.detailType);
            source(model.source);
        }

        public final String getDetailType() {
            return detailType;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public EventBridgeParameters build() {
            return new EventBridgeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
