/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakerruntime.model.SageMakerRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeEndpointWithResponseStreamRequest
extends SageMakerRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeEndpointWithResponseStreamRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::endpointName)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EndpointName").build()}).build();
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Body").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::body)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::contentType)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Accept").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::accept)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Accept").build()}).build();
    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAttributes").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::customAttributes)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes").build()}).build();
    private static final SdkField<String> TARGET_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVariant").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::targetVariant)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::targetVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Target-Variant").build()}).build();
    private static final SdkField<String> TARGET_CONTAINER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetContainerHostname").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::targetContainerHostname)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::targetContainerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Target-Container-Hostname").build()}).build();
    private static final SdkField<String> INFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceId").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::inferenceId)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::inferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Inference-Id").build()}).build();
    private static final SdkField<String> INFERENCE_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceComponentName").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::inferenceComponentName)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::inferenceComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Inference-Component").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(InvokeEndpointWithResponseStreamRequest.getter(InvokeEndpointWithResponseStreamRequest::sessionId)).setter(InvokeEndpointWithResponseStreamRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Session-Id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, BODY_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD, CUSTOM_ATTRIBUTES_FIELD, TARGET_VARIANT_FIELD, TARGET_CONTAINER_HOSTNAME_FIELD, INFERENCE_ID_FIELD, INFERENCE_COMPONENT_NAME_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointName", ENDPOINT_NAME_FIELD);
            this.put("Body", BODY_FIELD);
            this.put("Content-Type", CONTENT_TYPE_FIELD);
            this.put("X-Amzn-SageMaker-Accept", ACCEPT_FIELD);
            this.put("X-Amzn-SageMaker-Custom-Attributes", CUSTOM_ATTRIBUTES_FIELD);
            this.put("X-Amzn-SageMaker-Target-Variant", TARGET_VARIANT_FIELD);
            this.put("X-Amzn-SageMaker-Target-Container-Hostname", TARGET_CONTAINER_HOSTNAME_FIELD);
            this.put("X-Amzn-SageMaker-Inference-Id", INFERENCE_ID_FIELD);
            this.put("X-Amzn-SageMaker-Inference-Component", INFERENCE_COMPONENT_NAME_FIELD);
            this.put("X-Amzn-SageMaker-Session-Id", SESSION_ID_FIELD);
        }
    });
    private final String endpointName;
    private final SdkBytes body;
    private final String contentType;
    private final String accept;
    private final String customAttributes;
    private final String targetVariant;
    private final String targetContainerHostname;
    private final String inferenceId;
    private final String inferenceComponentName;
    private final String sessionId;

    private InvokeEndpointWithResponseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.customAttributes = builder.customAttributes;
        this.targetVariant = builder.targetVariant;
        this.targetContainerHostname = builder.targetContainerHostname;
        this.inferenceId = builder.inferenceId;
        this.inferenceComponentName = builder.inferenceComponentName;
        this.sessionId = builder.sessionId;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final SdkBytes body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String accept() {
        return this.accept;
    }

    public final String customAttributes() {
        return this.customAttributes;
    }

    public final String targetVariant() {
        return this.targetVariant;
    }

    public final String targetContainerHostname() {
        return this.targetContainerHostname;
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final String inferenceComponentName() {
        return this.inferenceComponentName;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetContainerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointWithResponseStreamRequest)) {
            return false;
        }
        InvokeEndpointWithResponseStreamRequest other = (InvokeEndpointWithResponseStreamRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.customAttributes(), other.customAttributes()) && Objects.equals(this.targetVariant(), other.targetVariant()) && Objects.equals(this.targetContainerHostname(), other.targetContainerHostname()) && Objects.equals(this.inferenceId(), other.inferenceId()) && Objects.equals(this.inferenceComponentName(), other.inferenceComponentName()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeEndpointWithResponseStreamRequest").add("EndpointName", (Object)this.endpointName()).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).add("CustomAttributes", (Object)(this.customAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetVariant", (Object)this.targetVariant()).add("TargetContainerHostname", (Object)this.targetContainerHostname()).add("InferenceId", (Object)this.inferenceId()).add("InferenceComponentName", (Object)this.inferenceComponentName()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
            case "TargetVariant": {
                return Optional.ofNullable(clazz.cast(this.targetVariant()));
            }
            case "TargetContainerHostname": {
                return Optional.ofNullable(clazz.cast(this.targetContainerHostname()));
            }
            case "InferenceId": {
                return Optional.ofNullable(clazz.cast(this.inferenceId()));
            }
            case "InferenceComponentName": {
                return Optional.ofNullable(clazz.cast(this.inferenceComponentName()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointWithResponseStreamRequest, T> g) {
        return obj -> g.apply((InvokeEndpointWithResponseStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRuntimeRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private SdkBytes body;
        private String contentType;
        private String accept;
        private String customAttributes;
        private String targetVariant;
        private String targetContainerHostname;
        private String inferenceId;
        private String inferenceComponentName;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointWithResponseStreamRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.body(model.body);
            this.contentType(model.contentType);
            this.accept(model.accept);
            this.customAttributes(model.customAttributes);
            this.targetVariant(model.targetVariant);
            this.targetContainerHostname(model.targetContainerHostname);
            this.inferenceId(model.inferenceId);
            this.inferenceComponentName(model.inferenceComponentName);
            this.sessionId(model.sessionId);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getCustomAttributes() {
            return this.customAttributes;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final String getTargetVariant() {
            return this.targetVariant;
        }

        public final void setTargetVariant(String targetVariant) {
            this.targetVariant = targetVariant;
        }

        @Override
        public final Builder targetVariant(String targetVariant) {
            this.targetVariant = targetVariant;
            return this;
        }

        public final String getTargetContainerHostname() {
            return this.targetContainerHostname;
        }

        public final void setTargetContainerHostname(String targetContainerHostname) {
            this.targetContainerHostname = targetContainerHostname;
        }

        @Override
        public final Builder targetContainerHostname(String targetContainerHostname) {
            this.targetContainerHostname = targetContainerHostname;
            return this;
        }

        public final String getInferenceId() {
            return this.inferenceId;
        }

        public final void setInferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
        }

        @Override
        public final Builder inferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
            return this;
        }

        public final String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        public final void setInferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
        }

        @Override
        public final Builder inferenceComponentName(String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeEndpointWithResponseStreamRequest build() {
            return new InvokeEndpointWithResponseStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeEndpointWithResponseStreamRequest> {
        public Builder endpointName(String var1);

        public Builder body(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder customAttributes(String var1);

        public Builder targetVariant(String var1);

        public Builder targetContainerHostname(String var1);

        public Builder inferenceId(String var1);

        public Builder inferenceComponentName(String var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

