/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemakerruntime.model.SageMakerRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeEndpointAsyncRequest
extends SageMakerRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeEndpointAsyncRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::endpointName)).setter(InvokeEndpointAsyncRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EndpointName").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::contentType)).setter(InvokeEndpointAsyncRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Content-Type").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Accept").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::accept)).setter(InvokeEndpointAsyncRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Accept").build()}).build();
    private static final SdkField<String> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomAttributes").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::customAttributes)).setter(InvokeEndpointAsyncRequest.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Custom-Attributes").build()}).build();
    private static final SdkField<String> INFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceId").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::inferenceId)).setter(InvokeEndpointAsyncRequest.setter(Builder::inferenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-Inference-Id").build()}).build();
    private static final SdkField<String> INPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputLocation").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::inputLocation)).setter(InvokeEndpointAsyncRequest.setter(Builder::inputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-InputLocation").build()}).build();
    private static final SdkField<Integer> REQUEST_TTL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RequestTTLSeconds").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::requestTTLSeconds)).setter(InvokeEndpointAsyncRequest.setter(Builder::requestTTLSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-RequestTTLSeconds").build()}).build();
    private static final SdkField<Integer> INVOCATION_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InvocationTimeoutSeconds").getter(InvokeEndpointAsyncRequest.getter(InvokeEndpointAsyncRequest::invocationTimeoutSeconds)).setter(InvokeEndpointAsyncRequest.setter(Builder::invocationTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-InvocationTimeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, CONTENT_TYPE_FIELD, ACCEPT_FIELD, CUSTOM_ATTRIBUTES_FIELD, INFERENCE_ID_FIELD, INPUT_LOCATION_FIELD, REQUEST_TTL_SECONDS_FIELD, INVOCATION_TIMEOUT_SECONDS_FIELD));
    private final String endpointName;
    private final String contentType;
    private final String accept;
    private final String customAttributes;
    private final String inferenceId;
    private final String inputLocation;
    private final Integer requestTTLSeconds;
    private final Integer invocationTimeoutSeconds;

    private InvokeEndpointAsyncRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.customAttributes = builder.customAttributes;
        this.inferenceId = builder.inferenceId;
        this.inputLocation = builder.inputLocation;
        this.requestTTLSeconds = builder.requestTTLSeconds;
        this.invocationTimeoutSeconds = builder.invocationTimeoutSeconds;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String accept() {
        return this.accept;
    }

    public final String customAttributes() {
        return this.customAttributes;
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final String inputLocation() {
        return this.inputLocation;
    }

    public final Integer requestTTLSeconds() {
        return this.requestTTLSeconds;
    }

    public final Integer invocationTimeoutSeconds() {
        return this.invocationTimeoutSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.customAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTTLSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTimeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointAsyncRequest)) {
            return false;
        }
        InvokeEndpointAsyncRequest other = (InvokeEndpointAsyncRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.customAttributes(), other.customAttributes()) && Objects.equals(this.inferenceId(), other.inferenceId()) && Objects.equals(this.inputLocation(), other.inputLocation()) && Objects.equals(this.requestTTLSeconds(), other.requestTTLSeconds()) && Objects.equals(this.invocationTimeoutSeconds(), other.invocationTimeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeEndpointAsyncRequest").add("EndpointName", (Object)this.endpointName()).add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).add("CustomAttributes", (Object)(this.customAttributes() == null ? null : "*** Sensitive Data Redacted ***")).add("InferenceId", (Object)this.inferenceId()).add("InputLocation", (Object)this.inputLocation()).add("RequestTTLSeconds", (Object)this.requestTTLSeconds()).add("InvocationTimeoutSeconds", (Object)this.invocationTimeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "Accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "CustomAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
            case "InferenceId": {
                return Optional.ofNullable(clazz.cast(this.inferenceId()));
            }
            case "InputLocation": {
                return Optional.ofNullable(clazz.cast(this.inputLocation()));
            }
            case "RequestTTLSeconds": {
                return Optional.ofNullable(clazz.cast(this.requestTTLSeconds()));
            }
            case "InvocationTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.invocationTimeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointAsyncRequest, T> g) {
        return obj -> g.apply((InvokeEndpointAsyncRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRuntimeRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String contentType;
        private String accept;
        private String customAttributes;
        private String inferenceId;
        private String inputLocation;
        private Integer requestTTLSeconds;
        private Integer invocationTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointAsyncRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.contentType(model.contentType);
            this.accept(model.accept);
            this.customAttributes(model.customAttributes);
            this.inferenceId(model.inferenceId);
            this.inputLocation(model.inputLocation);
            this.requestTTLSeconds(model.requestTTLSeconds);
            this.invocationTimeoutSeconds(model.invocationTimeoutSeconds);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getCustomAttributes() {
            return this.customAttributes;
        }

        public final void setCustomAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
        }

        @Override
        public final Builder customAttributes(String customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        public final String getInferenceId() {
            return this.inferenceId;
        }

        public final void setInferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
        }

        @Override
        public final Builder inferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
            return this;
        }

        public final String getInputLocation() {
            return this.inputLocation;
        }

        public final void setInputLocation(String inputLocation) {
            this.inputLocation = inputLocation;
        }

        @Override
        public final Builder inputLocation(String inputLocation) {
            this.inputLocation = inputLocation;
            return this;
        }

        public final Integer getRequestTTLSeconds() {
            return this.requestTTLSeconds;
        }

        public final void setRequestTTLSeconds(Integer requestTTLSeconds) {
            this.requestTTLSeconds = requestTTLSeconds;
        }

        @Override
        public final Builder requestTTLSeconds(Integer requestTTLSeconds) {
            this.requestTTLSeconds = requestTTLSeconds;
            return this;
        }

        public final Integer getInvocationTimeoutSeconds() {
            return this.invocationTimeoutSeconds;
        }

        public final void setInvocationTimeoutSeconds(Integer invocationTimeoutSeconds) {
            this.invocationTimeoutSeconds = invocationTimeoutSeconds;
        }

        @Override
        public final Builder invocationTimeoutSeconds(Integer invocationTimeoutSeconds) {
            this.invocationTimeoutSeconds = invocationTimeoutSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeEndpointAsyncRequest build() {
            return new InvokeEndpointAsyncRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeEndpointAsyncRequest> {
        public Builder endpointName(String var1);

        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder customAttributes(String var1);

        public Builder inferenceId(String var1);

        public Builder inputLocation(String var1);

        public Builder requestTTLSeconds(Integer var1);

        public Builder invocationTimeoutSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

