/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeEndpointAsyncResponse extends SageMakerRuntimeResponse implements
        ToCopyableBuilder<InvokeEndpointAsyncResponse.Builder, InvokeEndpointAsyncResponse> {
    private static final SdkField<String> INFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceId").getter(getter(InvokeEndpointAsyncResponse::inferenceId))
            .setter(setter(Builder::inferenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceId").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutputLocation")
            .getter(getter(InvokeEndpointAsyncResponse::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-SageMaker-OutputLocation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_ID_FIELD,
            OUTPUT_LOCATION_FIELD));

    private final String inferenceId;

    private final String outputLocation;

    private InvokeEndpointAsyncResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceId = builder.inferenceId;
        this.outputLocation = builder.outputLocation;
    }

    /**
     * <p>
     * Identifier for an inference request. This will be the same as the <code>InferenceId</code> specified in the
     * input. Amazon SageMaker will generate an identifier for you if you do not specify one.
     * </p>
     * 
     * @return Identifier for an inference request. This will be the same as the <code>InferenceId</code> specified in
     *         the input. Amazon SageMaker will generate an identifier for you if you do not specify one.
     */
    public final String inferenceId() {
        return inferenceId;
    }

    /**
     * <p>
     * The Amazon S3 URI where the inference response payload is stored.
     * </p>
     * 
     * @return The Amazon S3 URI where the inference response payload is stored.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceId());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeEndpointAsyncResponse)) {
            return false;
        }
        InvokeEndpointAsyncResponse other = (InvokeEndpointAsyncResponse) obj;
        return Objects.equals(inferenceId(), other.inferenceId()) && Objects.equals(outputLocation(), other.outputLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeEndpointAsyncResponse").add("InferenceId", inferenceId())
                .add("OutputLocation", outputLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceId":
            return Optional.ofNullable(clazz.cast(inferenceId()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeEndpointAsyncResponse, T> g) {
        return obj -> g.apply((InvokeEndpointAsyncResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeEndpointAsyncResponse> {
        /**
         * <p>
         * Identifier for an inference request. This will be the same as the <code>InferenceId</code> specified in the
         * input. Amazon SageMaker will generate an identifier for you if you do not specify one.
         * </p>
         * 
         * @param inferenceId
         *        Identifier for an inference request. This will be the same as the <code>InferenceId</code> specified
         *        in the input. Amazon SageMaker will generate an identifier for you if you do not specify one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceId(String inferenceId);

        /**
         * <p>
         * The Amazon S3 URI where the inference response payload is stored.
         * </p>
         * 
         * @param outputLocation
         *        The Amazon S3 URI where the inference response payload is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);
    }

    static final class BuilderImpl extends SageMakerRuntimeResponse.BuilderImpl implements Builder {
        private String inferenceId;

        private String outputLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeEndpointAsyncResponse model) {
            super(model);
            inferenceId(model.inferenceId);
            outputLocation(model.outputLocation);
        }

        public final String getInferenceId() {
            return inferenceId;
        }

        public final void setInferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
        }

        @Override
        public final Builder inferenceId(String inferenceId) {
            this.inferenceId = inferenceId;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        @Override
        public InvokeEndpointAsyncResponse build() {
            return new InvokeEndpointAsyncResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
