/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagsCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobStatus;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartVectorEnrichmentJobResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, StartVectorEnrichmentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::arn)).setter(StartVectorEnrichmentJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::creationTime)).setter(StartVectorEnrichmentJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInSeconds").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::durationInSeconds)).setter(StartVectorEnrichmentJobResponse.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::executionRoleArn)).setter(StartVectorEnrichmentJobResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<VectorEnrichmentJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::inputConfig)).setter(StartVectorEnrichmentJobResponse.setter(Builder::inputConfig)).constructor(VectorEnrichmentJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<VectorEnrichmentJobConfig> JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobConfig").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::jobConfig)).setter(StartVectorEnrichmentJobResponse.setter(Builder::jobConfig)).constructor(VectorEnrichmentJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::kmsKeyId)).setter(StartVectorEnrichmentJobResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::name)).setter(StartVectorEnrichmentJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::statusAsString)).setter(StartVectorEnrichmentJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::tags)).setter(StartVectorEnrichmentJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(StartVectorEnrichmentJobResponse.getter(StartVectorEnrichmentJobResponse::typeAsString)).setter(StartVectorEnrichmentJobResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DURATION_IN_SECONDS_FIELD, EXECUTION_ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartVectorEnrichmentJobResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant creationTime;
    private final Integer durationInSeconds;
    private final String executionRoleArn;
    private final VectorEnrichmentJobInputConfig inputConfig;
    private final VectorEnrichmentJobConfig jobConfig;
    private final String kmsKeyId;
    private final String name;
    private final String status;
    private final Map<String, String> tags;
    private final String type;

    private StartVectorEnrichmentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.executionRoleArn = builder.executionRoleArn;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VectorEnrichmentJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final VectorEnrichmentJobConfig jobConfig() {
        return this.jobConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String name() {
        return this.name;
    }

    public final VectorEnrichmentJobStatus status() {
        return VectorEnrichmentJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VectorEnrichmentJobType type() {
        return VectorEnrichmentJobType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVectorEnrichmentJobResponse)) {
            return false;
        }
        StartVectorEnrichmentJobResponse other = (StartVectorEnrichmentJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.jobConfig(), other.jobConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartVectorEnrichmentJobResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("InputConfig", (Object)this.inputConfig()).add("JobConfig", (Object)this.jobConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "JobConfig": {
                return Optional.ofNullable(clazz.cast(this.jobConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobConfig", JOB_CONFIG_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartVectorEnrichmentJobResponse, T> g) {
        return obj -> g.apply((StartVectorEnrichmentJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private Integer durationInSeconds;
        private String executionRoleArn;
        private VectorEnrichmentJobInputConfig inputConfig;
        private VectorEnrichmentJobConfig jobConfig;
        private String kmsKeyId;
        private String name;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVectorEnrichmentJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.durationInSeconds(model.durationInSeconds);
            this.executionRoleArn(model.executionRoleArn);
            this.inputConfig(model.inputConfig);
            this.jobConfig(model.jobConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.name(model.name);
            this.status(model.status);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VectorEnrichmentJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(VectorEnrichmentJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(VectorEnrichmentJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final VectorEnrichmentJobConfig.Builder getJobConfig() {
            return this.jobConfig != null ? this.jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(VectorEnrichmentJobConfig.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(VectorEnrichmentJobConfig jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VectorEnrichmentJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(VectorEnrichmentJobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public StartVectorEnrichmentJobResponse build() {
            return new StartVectorEnrichmentJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartVectorEnrichmentJobResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder durationInSeconds(Integer var1);

        public Builder executionRoleArn(String var1);

        public Builder inputConfig(VectorEnrichmentJobInputConfig var1);

        default public Builder inputConfig(Consumer<VectorEnrichmentJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((VectorEnrichmentJobInputConfig)((VectorEnrichmentJobInputConfig.Builder)VectorEnrichmentJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder jobConfig(VectorEnrichmentJobConfig var1);

        default public Builder jobConfig(Consumer<VectorEnrichmentJobConfig.Builder> jobConfig) {
            return this.jobConfig((VectorEnrichmentJobConfig)((VectorEnrichmentJobConfig.Builder)VectorEnrichmentJobConfig.builder().applyMutation(jobConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(VectorEnrichmentJobStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(VectorEnrichmentJobType var1);
    }
}

