/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialClient;
import software.amazon.awssdk.services.sagemakergeospatial.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobOutputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.ListEarthObservationJobsResponse;

public class ListEarthObservationJobsIterable
implements SdkIterable<ListEarthObservationJobsResponse> {
    private final SageMakerGeospatialClient client;
    private final ListEarthObservationJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEarthObservationJobsIterable(SageMakerGeospatialClient client, ListEarthObservationJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEarthObservationJobsResponseFetcher();
    }

    public Iterator<ListEarthObservationJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListEarthObservationJobOutputConfig> earthObservationJobSummaries() {
        Function<ListEarthObservationJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.earthObservationJobSummaries() != null) {
                return response.earthObservationJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEarthObservationJobsResponseFetcher
    implements SyncPageFetcher<ListEarthObservationJobsResponse> {
        private ListEarthObservationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListEarthObservationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEarthObservationJobsResponse nextPage(ListEarthObservationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListEarthObservationJobsIterable.this.client.listEarthObservationJobs(ListEarthObservationJobsIterable.this.firstRequest);
            }
            return ListEarthObservationJobsIterable.this.client.listEarthObservationJobs((ListEarthObservationJobsRequest)((Object)ListEarthObservationJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

