/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemakergeospatial.SageMakerGeospatialAsyncClient;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionRequest;
import software.amazon.awssdk.services.sagemakergeospatial.model.SearchRasterDataCollectionResponse;

public class SearchRasterDataCollectionPublisher
implements SdkPublisher<SearchRasterDataCollectionResponse> {
    private final SageMakerGeospatialAsyncClient client;
    private final SearchRasterDataCollectionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchRasterDataCollectionPublisher(SageMakerGeospatialAsyncClient client, SearchRasterDataCollectionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchRasterDataCollectionPublisher(SageMakerGeospatialAsyncClient client, SearchRasterDataCollectionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchRasterDataCollectionResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchRasterDataCollectionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchRasterDataCollectionResponseFetcher
    implements AsyncPageFetcher<SearchRasterDataCollectionResponse> {
        private SearchRasterDataCollectionResponseFetcher() {
        }

        public boolean hasNextPage(SearchRasterDataCollectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchRasterDataCollectionResponse> nextPage(SearchRasterDataCollectionResponse previousPage) {
            if (previousPage == null) {
                return SearchRasterDataCollectionPublisher.this.client.searchRasterDataCollection(SearchRasterDataCollectionPublisher.this.firstRequest);
            }
            return SearchRasterDataCollectionPublisher.this.client.searchRasterDataCollection((SearchRasterDataCollectionRequest)((Object)SearchRasterDataCollectionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

