/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.ExpirationTimeResponse;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.FeatureNamesCopier;
import software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.SageMakerFeatureStoreRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecordRequest
extends SageMakerFeatureStoreRuntimeRequest
implements ToCopyableBuilder<Builder, GetRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(GetRecordRequest.getter(GetRecordRequest::featureGroupName)).setter(GetRecordRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordIdentifierValueAsString").getter(GetRecordRequest.getter(GetRecordRequest::recordIdentifierValueAsString)).setter(GetRecordRequest.setter(Builder::recordIdentifierValueAsString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecordIdentifierValueAsString").build()}).build();
    private static final SdkField<List<String>> FEATURE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureNames").getter(GetRecordRequest.getter(GetRecordRequest::featureNames)).setter(GetRecordRequest.setter(Builder::featureNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FeatureName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXPIRATION_TIME_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationTimeResponse").getter(GetRecordRequest.getter(GetRecordRequest::expirationTimeResponseAsString)).setter(GetRecordRequest.setter(Builder::expirationTimeResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ExpirationTimeResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, FEATURE_NAMES_FIELD, EXPIRATION_TIME_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecordRequest.memberNameToFieldInitializer();
    private final String featureGroupName;
    private final String recordIdentifierValueAsString;
    private final List<String> featureNames;
    private final String expirationTimeResponse;

    private GetRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.featureNames = builder.featureNames;
        this.expirationTimeResponse = builder.expirationTimeResponse;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String recordIdentifierValueAsString() {
        return this.recordIdentifierValueAsString;
    }

    public final boolean hasFeatureNames() {
        return this.featureNames != null && !(this.featureNames instanceof SdkAutoConstructList);
    }

    public final List<String> featureNames() {
        return this.featureNames;
    }

    public final ExpirationTimeResponse expirationTimeResponse() {
        return ExpirationTimeResponse.fromValue(this.expirationTimeResponse);
    }

    public final String expirationTimeResponseAsString() {
        return this.expirationTimeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureNames() ? this.featureNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTimeResponseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordRequest)) {
            return false;
        }
        GetRecordRequest other = (GetRecordRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.recordIdentifierValueAsString(), other.recordIdentifierValueAsString()) && this.hasFeatureNames() == other.hasFeatureNames() && Objects.equals(this.featureNames(), other.featureNames()) && Objects.equals(this.expirationTimeResponseAsString(), other.expirationTimeResponseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecordRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("RecordIdentifierValueAsString", (Object)this.recordIdentifierValueAsString()).add("FeatureNames", this.hasFeatureNames() ? this.featureNames() : null).add("ExpirationTimeResponse", (Object)this.expirationTimeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "RecordIdentifierValueAsString": {
                return Optional.ofNullable(clazz.cast(this.recordIdentifierValueAsString()));
            }
            case "FeatureNames": {
                return Optional.ofNullable(clazz.cast(this.featureNames()));
            }
            case "ExpirationTimeResponse": {
                return Optional.ofNullable(clazz.cast(this.expirationTimeResponseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("RecordIdentifierValueAsString", RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD);
        map.put("FeatureName", FEATURE_NAMES_FIELD);
        map.put("ExpirationTimeResponse", EXPIRATION_TIME_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecordRequest, T> g) {
        return obj -> g.apply((GetRecordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private String recordIdentifierValueAsString;
        private List<String> featureNames = DefaultSdkAutoConstructList.getInstance();
        private String expirationTimeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            this.featureNames(model.featureNames);
            this.expirationTimeResponse(model.expirationTimeResponse);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierValueAsString() {
            return this.recordIdentifierValueAsString;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final Collection<String> getFeatureNames() {
            if (this.featureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureNames;
        }

        public final void setFeatureNames(Collection<String> featureNames) {
            this.featureNames = FeatureNamesCopier.copy(featureNames);
        }

        @Override
        public final Builder featureNames(Collection<String> featureNames) {
            this.featureNames = FeatureNamesCopier.copy(featureNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureNames(String ... featureNames) {
            this.featureNames(Arrays.asList(featureNames));
            return this;
        }

        public final String getExpirationTimeResponse() {
            return this.expirationTimeResponse;
        }

        public final void setExpirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
        }

        @Override
        public final Builder expirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
            return this;
        }

        @Override
        public final Builder expirationTimeResponse(ExpirationTimeResponse expirationTimeResponse) {
            this.expirationTimeResponse(expirationTimeResponse == null ? null : expirationTimeResponse.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecordRequest build() {
            return new GetRecordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerFeatureStoreRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecordRequest> {
        public Builder featureGroupName(String var1);

        public Builder recordIdentifierValueAsString(String var1);

        public Builder featureNames(Collection<String> var1);

        public Builder featureNames(String ... var1);

        public Builder expirationTimeResponse(String var1);

        public Builder expirationTimeResponse(ExpirationTimeResponse var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

