/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.JoinSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataProcessing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataProcessing> {
    private static final SdkField<String> INPUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataProcessing.getter(DataProcessing::inputFilter)).setter(DataProcessing.setter(Builder::inputFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFilter").build()}).build();
    private static final SdkField<String> OUTPUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataProcessing.getter(DataProcessing::outputFilter)).setter(DataProcessing.setter(Builder::outputFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFilter").build()}).build();
    private static final SdkField<String> JOIN_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataProcessing.getter(DataProcessing::joinSourceAsString)).setter(DataProcessing.setter(Builder::joinSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JoinSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FILTER_FIELD, OUTPUT_FILTER_FIELD, JOIN_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputFilter;
    private final String outputFilter;
    private final String joinSource;

    private DataProcessing(BuilderImpl builder) {
        this.inputFilter = builder.inputFilter;
        this.outputFilter = builder.outputFilter;
        this.joinSource = builder.joinSource;
    }

    public String inputFilter() {
        return this.inputFilter;
    }

    public String outputFilter() {
        return this.outputFilter;
    }

    public JoinSource joinSource() {
        return JoinSource.fromValue(this.joinSource);
    }

    public String joinSourceAsString() {
        return this.joinSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.joinSourceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProcessing)) {
            return false;
        }
        DataProcessing other = (DataProcessing)obj;
        return Objects.equals(this.inputFilter(), other.inputFilter()) && Objects.equals(this.outputFilter(), other.outputFilter()) && Objects.equals(this.joinSourceAsString(), other.joinSourceAsString());
    }

    public String toString() {
        return ToString.builder((String)"DataProcessing").add("InputFilter", (Object)this.inputFilter()).add("OutputFilter", (Object)this.outputFilter()).add("JoinSource", (Object)this.joinSourceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputFilter": {
                return Optional.ofNullable(clazz.cast(this.inputFilter()));
            }
            case "OutputFilter": {
                return Optional.ofNullable(clazz.cast(this.outputFilter()));
            }
            case "JoinSource": {
                return Optional.ofNullable(clazz.cast(this.joinSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataProcessing, T> g) {
        return obj -> g.apply((DataProcessing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputFilter;
        private String outputFilter;
        private String joinSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProcessing model) {
            this.inputFilter(model.inputFilter);
            this.outputFilter(model.outputFilter);
            this.joinSource(model.joinSource);
        }

        public final String getInputFilter() {
            return this.inputFilter;
        }

        @Override
        public final Builder inputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
            return this;
        }

        public final void setInputFilter(String inputFilter) {
            this.inputFilter = inputFilter;
        }

        public final String getOutputFilter() {
            return this.outputFilter;
        }

        @Override
        public final Builder outputFilter(String outputFilter) {
            this.outputFilter = outputFilter;
            return this;
        }

        public final void setOutputFilter(String outputFilter) {
            this.outputFilter = outputFilter;
        }

        public final String getJoinSourceAsString() {
            return this.joinSource;
        }

        @Override
        public final Builder joinSource(String joinSource) {
            this.joinSource = joinSource;
            return this;
        }

        @Override
        public final Builder joinSource(JoinSource joinSource) {
            this.joinSource(joinSource == null ? null : joinSource.toString());
            return this;
        }

        public final void setJoinSource(String joinSource) {
            this.joinSource = joinSource;
        }

        public DataProcessing build() {
            return new DataProcessing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataProcessing> {
        public Builder inputFilter(String var1);

        public Builder outputFilter(String var1);

        public Builder joinSource(String var1);

        public Builder joinSource(JoinSource var1);
    }
}

