/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobStatus;
import software.amazon.awssdk.services.sagemaker.model.TargetDevice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompilationJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompilationJobSummary> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompilationJobSummary.getter(CompilationJobSummary::compilationJobName)).setter(CompilationJobSummary.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompilationJobSummary.getter(CompilationJobSummary::compilationJobArn)).setter(CompilationJobSummary.setter(Builder::compilationJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CompilationJobSummary.getter(CompilationJobSummary::creationTime)).setter(CompilationJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CompilationJobSummary.getter(CompilationJobSummary::compilationStartTime)).setter(CompilationJobSummary.setter(Builder::compilationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build()}).build();
    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CompilationJobSummary.getter(CompilationJobSummary::compilationEndTime)).setter(CompilationJobSummary.setter(Builder::compilationEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build()}).build();
    private static final SdkField<String> COMPILATION_TARGET_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompilationJobSummary.getter(CompilationJobSummary::compilationTargetDeviceAsString)).setter(CompilationJobSummary.setter(Builder::compilationTargetDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetDevice").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CompilationJobSummary.getter(CompilationJobSummary::lastModifiedTime)).setter(CompilationJobSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CompilationJobSummary.getter(CompilationJobSummary::compilationJobStatusAsString)).setter(CompilationJobSummary.setter(Builder::compilationJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD, COMPILATION_JOB_ARN_FIELD, CREATION_TIME_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD, COMPILATION_TARGET_DEVICE_FIELD, LAST_MODIFIED_TIME_FIELD, COMPILATION_JOB_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String compilationJobName;
    private final String compilationJobArn;
    private final Instant creationTime;
    private final Instant compilationStartTime;
    private final Instant compilationEndTime;
    private final String compilationTargetDevice;
    private final Instant lastModifiedTime;
    private final String compilationJobStatus;

    private CompilationJobSummary(BuilderImpl builder) {
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.creationTime = builder.creationTime;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.compilationTargetDevice = builder.compilationTargetDevice;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.compilationJobStatus = builder.compilationJobStatus;
    }

    public String compilationJobName() {
        return this.compilationJobName;
    }

    public String compilationJobArn() {
        return this.compilationJobArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant compilationStartTime() {
        return this.compilationStartTime;
    }

    public Instant compilationEndTime() {
        return this.compilationEndTime;
    }

    public TargetDevice compilationTargetDevice() {
        return TargetDevice.fromValue(this.compilationTargetDevice);
    }

    public String compilationTargetDeviceAsString() {
        return this.compilationTargetDevice;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(this.compilationJobStatus);
    }

    public String compilationJobStatusAsString() {
        return this.compilationJobStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationTargetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompilationJobSummary)) {
            return false;
        }
        CompilationJobSummary other = (CompilationJobSummary)obj;
        return Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.compilationJobArn(), other.compilationJobArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.compilationStartTime(), other.compilationStartTime()) && Objects.equals(this.compilationEndTime(), other.compilationEndTime()) && Objects.equals(this.compilationTargetDeviceAsString(), other.compilationTargetDeviceAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.compilationJobStatusAsString(), other.compilationJobStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"CompilationJobSummary").add("CompilationJobName", (Object)this.compilationJobName()).add("CompilationJobArn", (Object)this.compilationJobArn()).add("CreationTime", (Object)this.creationTime()).add("CompilationStartTime", (Object)this.compilationStartTime()).add("CompilationEndTime", (Object)this.compilationEndTime()).add("CompilationTargetDevice", (Object)this.compilationTargetDeviceAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CompilationJobStatus", (Object)this.compilationJobStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "CompilationJobArn": {
                return Optional.ofNullable(clazz.cast(this.compilationJobArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompilationStartTime": {
                return Optional.ofNullable(clazz.cast(this.compilationStartTime()));
            }
            case "CompilationEndTime": {
                return Optional.ofNullable(clazz.cast(this.compilationEndTime()));
            }
            case "CompilationTargetDevice": {
                return Optional.ofNullable(clazz.cast(this.compilationTargetDeviceAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CompilationJobStatus": {
                return Optional.ofNullable(clazz.cast(this.compilationJobStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompilationJobSummary, T> g) {
        return obj -> g.apply((CompilationJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String compilationJobName;
        private String compilationJobArn;
        private Instant creationTime;
        private Instant compilationStartTime;
        private Instant compilationEndTime;
        private String compilationTargetDevice;
        private Instant lastModifiedTime;
        private String compilationJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CompilationJobSummary model) {
            this.compilationJobName(model.compilationJobName);
            this.compilationJobArn(model.compilationJobArn);
            this.creationTime(model.creationTime);
            this.compilationStartTime(model.compilationStartTime);
            this.compilationEndTime(model.compilationEndTime);
            this.compilationTargetDevice(model.compilationTargetDevice);
            this.lastModifiedTime(model.lastModifiedTime);
            this.compilationJobStatus(model.compilationJobStatus);
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        public final String getCompilationJobArn() {
            return this.compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getCompilationStartTime() {
            return this.compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        public final Instant getCompilationEndTime() {
            return this.compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        public final String getCompilationTargetDeviceAsString() {
            return this.compilationTargetDevice;
        }

        @Override
        public final Builder compilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
            return this;
        }

        @Override
        public final Builder compilationTargetDevice(TargetDevice compilationTargetDevice) {
            this.compilationTargetDevice(compilationTargetDevice == null ? null : compilationTargetDevice.toString());
            return this;
        }

        public final void setCompilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getCompilationJobStatusAsString() {
            return this.compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        public CompilationJobSummary build() {
            return new CompilationJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompilationJobSummary> {
        public Builder compilationJobName(String var1);

        public Builder compilationJobArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder compilationStartTime(Instant var1);

        public Builder compilationEndTime(Instant var1);

        public Builder compilationTargetDevice(String var1);

        public Builder compilationTargetDevice(TargetDevice var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder compilationJobStatus(String var1);

        public Builder compilationJobStatus(CompilationJobStatus var1);
    }
}

