/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ContentClassifier;
import software.amazon.awssdk.services.sagemaker.model.ContentClassifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobDataAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobDataAttributes> {
    private static final SdkField<List<String>> CONTENT_CLASSIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LabelingJobDataAttributes.getter(LabelingJobDataAttributes::contentClassifiersAsStrings)).setter(LabelingJobDataAttributes.setter(Builder::contentClassifiersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentClassifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_CLASSIFIERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> contentClassifiers;

    private LabelingJobDataAttributes(BuilderImpl builder) {
        this.contentClassifiers = builder.contentClassifiers;
    }

    public List<ContentClassifier> contentClassifiers() {
        return ContentClassifiersCopier.copyStringToEnum(this.contentClassifiers);
    }

    public List<String> contentClassifiersAsStrings() {
        return this.contentClassifiers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contentClassifiersAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobDataAttributes)) {
            return false;
        }
        LabelingJobDataAttributes other = (LabelingJobDataAttributes)obj;
        return Objects.equals(this.contentClassifiersAsStrings(), other.contentClassifiersAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"LabelingJobDataAttributes").add("ContentClassifiers", this.contentClassifiersAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentClassifiers": {
                return Optional.ofNullable(clazz.cast(this.contentClassifiersAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobDataAttributes, T> g) {
        return obj -> g.apply((LabelingJobDataAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> contentClassifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobDataAttributes model) {
            this.contentClassifiersWithStrings(model.contentClassifiers);
        }

        public final Collection<String> getContentClassifiersAsStrings() {
            return this.contentClassifiers;
        }

        @Override
        public final Builder contentClassifiersWithStrings(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiersWithStrings(String ... contentClassifiers) {
            this.contentClassifiersWithStrings(Arrays.asList(contentClassifiers));
            return this;
        }

        @Override
        public final Builder contentClassifiers(Collection<ContentClassifier> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copyEnumToString(contentClassifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentClassifiers(ContentClassifier ... contentClassifiers) {
            this.contentClassifiers(Arrays.asList(contentClassifiers));
            return this;
        }

        public final void setContentClassifiersWithStrings(Collection<String> contentClassifiers) {
            this.contentClassifiers = ContentClassifiersCopier.copy(contentClassifiers);
        }

        public LabelingJobDataAttributes build() {
            return new LabelingJobDataAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobDataAttributes> {
        public Builder contentClassifiersWithStrings(Collection<String> var1);

        public Builder contentClassifiersWithStrings(String ... var1);

        public Builder contentClassifiers(Collection<ContentClassifier> var1);

        public Builder contentClassifiers(ContentClassifier ... var1);
    }
}

