/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntegerParameterRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntegerParameterRange> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntegerParameterRange.getter(IntegerParameterRange::name)).setter(IntegerParameterRange.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MIN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntegerParameterRange.getter(IntegerParameterRange::minValue)).setter(IntegerParameterRange.setter(Builder::minValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()}).build();
    private static final SdkField<String> MAX_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntegerParameterRange.getter(IntegerParameterRange::maxValue)).setter(IntegerParameterRange.setter(Builder::maxValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()}).build();
    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IntegerParameterRange.getter(IntegerParameterRange::scalingTypeAsString)).setter(IntegerParameterRange.setter(Builder::scalingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MIN_VALUE_FIELD, MAX_VALUE_FIELD, SCALING_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String minValue;
    private final String maxValue;
    private final String scalingType;

    private IntegerParameterRange(BuilderImpl builder) {
        this.name = builder.name;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.scalingType = builder.scalingType;
    }

    public String name() {
        return this.name;
    }

    public String minValue() {
        return this.minValue;
    }

    public String maxValue() {
        return this.maxValue;
    }

    public HyperParameterScalingType scalingType() {
        return HyperParameterScalingType.fromValue(this.scalingType);
    }

    public String scalingTypeAsString() {
        return this.scalingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.minValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerParameterRange)) {
            return false;
        }
        IntegerParameterRange other = (IntegerParameterRange)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.minValue(), other.minValue()) && Objects.equals(this.maxValue(), other.maxValue()) && Objects.equals(this.scalingTypeAsString(), other.scalingTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"IntegerParameterRange").add("Name", (Object)this.name()).add("MinValue", (Object)this.minValue()).add("MaxValue", (Object)this.maxValue()).add("ScalingType", (Object)this.scalingTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MinValue": {
                return Optional.ofNullable(clazz.cast(this.minValue()));
            }
            case "MaxValue": {
                return Optional.ofNullable(clazz.cast(this.maxValue()));
            }
            case "ScalingType": {
                return Optional.ofNullable(clazz.cast(this.scalingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegerParameterRange, T> g) {
        return obj -> g.apply((IntegerParameterRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String minValue;
        private String maxValue;
        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegerParameterRange model) {
            this.name(model.name);
            this.minValue(model.minValue);
            this.maxValue(model.maxValue);
            this.scalingType(model.scalingType);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMinValue() {
            return this.minValue;
        }

        @Override
        public final Builder minValue(String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(String minValue) {
            this.minValue = minValue;
        }

        public final String getMaxValue() {
            return this.maxValue;
        }

        @Override
        public final Builder maxValue(String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(String maxValue) {
            this.maxValue = maxValue;
        }

        public final String getScalingTypeAsString() {
            return this.scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(HyperParameterScalingType scalingType) {
            this.scalingType(scalingType.toString());
            return this;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        public IntegerParameterRange build() {
            return new IntegerParameterRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntegerParameterRange> {
        public Builder name(String var1);

        public Builder minValue(String var1);

        public Builder maxValue(String var1);

        public Builder scalingType(String var1);

        public Builder scalingType(HyperParameterScalingType var1);
    }
}

