/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteam;
import software.amazon.awssdk.services.sagemaker.model.SubscribedWorkteamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubscribedWorkteamsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListSubscribedWorkteamsResponse> {
    private static final SdkField<List<SubscribedWorkteam>> SUBSCRIBED_WORKTEAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListSubscribedWorkteamsResponse.getter(ListSubscribedWorkteamsResponse::subscribedWorkteams)).setter(ListSubscribedWorkteamsResponse.setter(Builder::subscribedWorkteams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedWorkteams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedWorkteam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListSubscribedWorkteamsResponse.getter(ListSubscribedWorkteamsResponse::nextToken)).setter(ListSubscribedWorkteamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIBED_WORKTEAMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SubscribedWorkteam> subscribedWorkteams;
    private final String nextToken;

    private ListSubscribedWorkteamsResponse(BuilderImpl builder) {
        super(builder);
        this.subscribedWorkteams = builder.subscribedWorkteams;
        this.nextToken = builder.nextToken;
    }

    public List<SubscribedWorkteam> subscribedWorkteams() {
        return this.subscribedWorkteams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedWorkteams());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubscribedWorkteamsResponse)) {
            return false;
        }
        ListSubscribedWorkteamsResponse other = (ListSubscribedWorkteamsResponse)((Object)obj);
        return Objects.equals(this.subscribedWorkteams(), other.subscribedWorkteams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListSubscribedWorkteamsResponse").add("SubscribedWorkteams", this.subscribedWorkteams()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscribedWorkteams": {
                return Optional.ofNullable(clazz.cast(this.subscribedWorkteams()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSubscribedWorkteamsResponse, T> g) {
        return obj -> g.apply((ListSubscribedWorkteamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<SubscribedWorkteam> subscribedWorkteams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubscribedWorkteamsResponse model) {
            super(model);
            this.subscribedWorkteams(model.subscribedWorkteams);
            this.nextToken(model.nextToken);
        }

        public final Collection<SubscribedWorkteam.Builder> getSubscribedWorkteams() {
            return this.subscribedWorkteams != null ? (Collection)this.subscribedWorkteams.stream().map(SubscribedWorkteam::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribedWorkteams(Collection<SubscribedWorkteam> subscribedWorkteams) {
            this.subscribedWorkteams = SubscribedWorkteamsCopier.copy(subscribedWorkteams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedWorkteams(SubscribedWorkteam ... subscribedWorkteams) {
            this.subscribedWorkteams(Arrays.asList(subscribedWorkteams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedWorkteams(Consumer<SubscribedWorkteam.Builder> ... subscribedWorkteams) {
            this.subscribedWorkteams(Stream.of(subscribedWorkteams).map(c -> (SubscribedWorkteam)((SubscribedWorkteam.Builder)SubscribedWorkteam.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribedWorkteams(Collection<SubscribedWorkteam.BuilderImpl> subscribedWorkteams) {
            this.subscribedWorkteams = SubscribedWorkteamsCopier.copyFromBuilder(subscribedWorkteams);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSubscribedWorkteamsResponse build() {
            return new ListSubscribedWorkteamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubscribedWorkteamsResponse> {
        public Builder subscribedWorkteams(Collection<SubscribedWorkteam> var1);

        public Builder subscribedWorkteams(SubscribedWorkteam ... var1);

        public Builder subscribedWorkteams(Consumer<SubscribedWorkteam.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

