/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LabelCountersForWorkteam;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobForWorkteamSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobForWorkteamSummary> {
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::labelingJobName)).setter(LabelingJobForWorkteamSummary.setter(Builder::labelingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()}).build();
    private static final SdkField<String> JOB_REFERENCE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::jobReferenceCode)).setter(LabelingJobForWorkteamSummary.setter(Builder::jobReferenceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCode").build()}).build();
    private static final SdkField<String> WORK_REQUESTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::workRequesterAccountId)).setter(LabelingJobForWorkteamSummary.setter(Builder::workRequesterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkRequesterAccountId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::creationTime)).setter(LabelingJobForWorkteamSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<LabelCountersForWorkteam> LABEL_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LabelingJobForWorkteamSummary.getter(LabelingJobForWorkteamSummary::labelCounters)).setter(LabelingJobForWorkteamSummary.setter(Builder::labelCounters)).constructor(LabelCountersForWorkteam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_NAME_FIELD, JOB_REFERENCE_CODE_FIELD, WORK_REQUESTER_ACCOUNT_ID_FIELD, CREATION_TIME_FIELD, LABEL_COUNTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String labelingJobName;
    private final String jobReferenceCode;
    private final String workRequesterAccountId;
    private final Instant creationTime;
    private final LabelCountersForWorkteam labelCounters;

    private LabelingJobForWorkteamSummary(BuilderImpl builder) {
        this.labelingJobName = builder.labelingJobName;
        this.jobReferenceCode = builder.jobReferenceCode;
        this.workRequesterAccountId = builder.workRequesterAccountId;
        this.creationTime = builder.creationTime;
        this.labelCounters = builder.labelCounters;
    }

    public String labelingJobName() {
        return this.labelingJobName;
    }

    public String jobReferenceCode() {
        return this.jobReferenceCode;
    }

    public String workRequesterAccountId() {
        return this.workRequesterAccountId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public LabelCountersForWorkteam labelCounters() {
        return this.labelCounters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobReferenceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.workRequesterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCounters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobForWorkteamSummary)) {
            return false;
        }
        LabelingJobForWorkteamSummary other = (LabelingJobForWorkteamSummary)obj;
        return Objects.equals(this.labelingJobName(), other.labelingJobName()) && Objects.equals(this.jobReferenceCode(), other.jobReferenceCode()) && Objects.equals(this.workRequesterAccountId(), other.workRequesterAccountId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.labelCounters(), other.labelCounters());
    }

    public String toString() {
        return ToString.builder((String)"LabelingJobForWorkteamSummary").add("LabelingJobName", (Object)this.labelingJobName()).add("JobReferenceCode", (Object)this.jobReferenceCode()).add("WorkRequesterAccountId", (Object)this.workRequesterAccountId()).add("CreationTime", (Object)this.creationTime()).add("LabelCounters", (Object)this.labelCounters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobName": {
                return Optional.ofNullable(clazz.cast(this.labelingJobName()));
            }
            case "JobReferenceCode": {
                return Optional.ofNullable(clazz.cast(this.jobReferenceCode()));
            }
            case "WorkRequesterAccountId": {
                return Optional.ofNullable(clazz.cast(this.workRequesterAccountId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LabelCounters": {
                return Optional.ofNullable(clazz.cast(this.labelCounters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobForWorkteamSummary, T> g) {
        return obj -> g.apply((LabelingJobForWorkteamSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String labelingJobName;
        private String jobReferenceCode;
        private String workRequesterAccountId;
        private Instant creationTime;
        private LabelCountersForWorkteam labelCounters;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobForWorkteamSummary model) {
            this.labelingJobName(model.labelingJobName);
            this.jobReferenceCode(model.jobReferenceCode);
            this.workRequesterAccountId(model.workRequesterAccountId);
            this.creationTime(model.creationTime);
            this.labelCounters(model.labelCounters);
        }

        public final String getLabelingJobName() {
            return this.labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        public final String getJobReferenceCode() {
            return this.jobReferenceCode;
        }

        @Override
        public final Builder jobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
            return this;
        }

        public final void setJobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
        }

        public final String getWorkRequesterAccountId() {
            return this.workRequesterAccountId;
        }

        @Override
        public final Builder workRequesterAccountId(String workRequesterAccountId) {
            this.workRequesterAccountId = workRequesterAccountId;
            return this;
        }

        public final void setWorkRequesterAccountId(String workRequesterAccountId) {
            this.workRequesterAccountId = workRequesterAccountId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final LabelCountersForWorkteam.Builder getLabelCounters() {
            return this.labelCounters != null ? this.labelCounters.toBuilder() : null;
        }

        @Override
        public final Builder labelCounters(LabelCountersForWorkteam labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final void setLabelCounters(LabelCountersForWorkteam.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        public LabelingJobForWorkteamSummary build() {
            return new LabelingJobForWorkteamSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobForWorkteamSummary> {
        public Builder labelingJobName(String var1);

        public Builder jobReferenceCode(String var1);

        public Builder workRequesterAccountId(String var1);

        public Builder creationTime(Instant var1);

        public Builder labelCounters(LabelCountersForWorkteam var1);

        default public Builder labelCounters(Consumer<LabelCountersForWorkteam.Builder> labelCounters) {
            return this.labelCounters((LabelCountersForWorkteam)((LabelCountersForWorkteam.Builder)LabelCountersForWorkteam.builder().applyMutation(labelCounters)).build());
        }
    }
}

