/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DesiredWeightAndCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DesiredWeightAndCapacity> {
    private static final SdkField<String> VARIANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::variantName)).setter(DesiredWeightAndCapacity.setter(Builder::variantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VariantName").build()}).build();
    private static final SdkField<Float> DESIRED_WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::desiredWeight)).setter(DesiredWeightAndCapacity.setter(Builder::desiredWeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredWeight").build()}).build();
    private static final SdkField<Integer> DESIRED_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DesiredWeightAndCapacity.getter(DesiredWeightAndCapacity::desiredInstanceCount)).setter(DesiredWeightAndCapacity.setter(Builder::desiredInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstanceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_NAME_FIELD, DESIRED_WEIGHT_FIELD, DESIRED_INSTANCE_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String variantName;
    private final Float desiredWeight;
    private final Integer desiredInstanceCount;

    private DesiredWeightAndCapacity(BuilderImpl builder) {
        this.variantName = builder.variantName;
        this.desiredWeight = builder.desiredWeight;
        this.desiredInstanceCount = builder.desiredInstanceCount;
    }

    public String variantName() {
        return this.variantName;
    }

    public Float desiredWeight() {
        return this.desiredWeight;
    }

    public Integer desiredInstanceCount() {
        return this.desiredInstanceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variantName());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredWeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredInstanceCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DesiredWeightAndCapacity)) {
            return false;
        }
        DesiredWeightAndCapacity other = (DesiredWeightAndCapacity)obj;
        return Objects.equals(this.variantName(), other.variantName()) && Objects.equals(this.desiredWeight(), other.desiredWeight()) && Objects.equals(this.desiredInstanceCount(), other.desiredInstanceCount());
    }

    public String toString() {
        return ToString.builder((String)"DesiredWeightAndCapacity").add("VariantName", (Object)this.variantName()).add("DesiredWeight", (Object)this.desiredWeight()).add("DesiredInstanceCount", (Object)this.desiredInstanceCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VariantName": {
                return Optional.ofNullable(clazz.cast(this.variantName()));
            }
            case "DesiredWeight": {
                return Optional.ofNullable(clazz.cast(this.desiredWeight()));
            }
            case "DesiredInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.desiredInstanceCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DesiredWeightAndCapacity, T> g) {
        return obj -> g.apply((DesiredWeightAndCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String variantName;
        private Float desiredWeight;
        private Integer desiredInstanceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DesiredWeightAndCapacity model) {
            this.variantName(model.variantName);
            this.desiredWeight(model.desiredWeight);
            this.desiredInstanceCount(model.desiredInstanceCount);
        }

        public final String getVariantName() {
            return this.variantName;
        }

        @Override
        public final Builder variantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public final void setVariantName(String variantName) {
            this.variantName = variantName;
        }

        public final Float getDesiredWeight() {
            return this.desiredWeight;
        }

        @Override
        public final Builder desiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
            return this;
        }

        public final void setDesiredWeight(Float desiredWeight) {
            this.desiredWeight = desiredWeight;
        }

        public final Integer getDesiredInstanceCount() {
            return this.desiredInstanceCount;
        }

        @Override
        public final Builder desiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
            return this;
        }

        public final void setDesiredInstanceCount(Integer desiredInstanceCount) {
            this.desiredInstanceCount = desiredInstanceCount;
        }

        public DesiredWeightAndCapacity build() {
            return new DesiredWeightAndCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DesiredWeightAndCapacity> {
        public Builder variantName(String var1);

        public Builder desiredWeight(Float var1);

        public Builder desiredInstanceCount(Integer var1);
    }
}

