/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobOutput> {
    private static final SdkField<String> OUTPUT_DATASET_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LabelingJobOutput.getter(LabelingJobOutput::outputDatasetS3Uri)).setter(LabelingJobOutput.setter(Builder::outputDatasetS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDatasetS3Uri").build()}).build();
    private static final SdkField<String> FINAL_ACTIVE_LEARNING_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LabelingJobOutput.getter(LabelingJobOutput::finalActiveLearningModelArn)).setter(LabelingJobOutput.setter(Builder::finalActiveLearningModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalActiveLearningModelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_DATASET_S3_URI_FIELD, FINAL_ACTIVE_LEARNING_MODEL_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String outputDatasetS3Uri;
    private final String finalActiveLearningModelArn;

    private LabelingJobOutput(BuilderImpl builder) {
        this.outputDatasetS3Uri = builder.outputDatasetS3Uri;
        this.finalActiveLearningModelArn = builder.finalActiveLearningModelArn;
    }

    public String outputDatasetS3Uri() {
        return this.outputDatasetS3Uri;
    }

    public String finalActiveLearningModelArn() {
        return this.finalActiveLearningModelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDatasetS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalActiveLearningModelArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobOutput)) {
            return false;
        }
        LabelingJobOutput other = (LabelingJobOutput)obj;
        return Objects.equals(this.outputDatasetS3Uri(), other.outputDatasetS3Uri()) && Objects.equals(this.finalActiveLearningModelArn(), other.finalActiveLearningModelArn());
    }

    public String toString() {
        return ToString.builder((String)"LabelingJobOutput").add("OutputDatasetS3Uri", (Object)this.outputDatasetS3Uri()).add("FinalActiveLearningModelArn", (Object)this.finalActiveLearningModelArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputDatasetS3Uri": {
                return Optional.ofNullable(clazz.cast(this.outputDatasetS3Uri()));
            }
            case "FinalActiveLearningModelArn": {
                return Optional.ofNullable(clazz.cast(this.finalActiveLearningModelArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobOutput, T> g) {
        return obj -> g.apply((LabelingJobOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputDatasetS3Uri;
        private String finalActiveLearningModelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobOutput model) {
            this.outputDatasetS3Uri(model.outputDatasetS3Uri);
            this.finalActiveLearningModelArn(model.finalActiveLearningModelArn);
        }

        public final String getOutputDatasetS3Uri() {
            return this.outputDatasetS3Uri;
        }

        @Override
        public final Builder outputDatasetS3Uri(String outputDatasetS3Uri) {
            this.outputDatasetS3Uri = outputDatasetS3Uri;
            return this;
        }

        public final void setOutputDatasetS3Uri(String outputDatasetS3Uri) {
            this.outputDatasetS3Uri = outputDatasetS3Uri;
        }

        public final String getFinalActiveLearningModelArn() {
            return this.finalActiveLearningModelArn;
        }

        @Override
        public final Builder finalActiveLearningModelArn(String finalActiveLearningModelArn) {
            this.finalActiveLearningModelArn = finalActiveLearningModelArn;
            return this;
        }

        public final void setFinalActiveLearningModelArn(String finalActiveLearningModelArn) {
            this.finalActiveLearningModelArn = finalActiveLearningModelArn;
        }

        public LabelingJobOutput build() {
            return new LabelingJobOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobOutput> {
        public Builder outputDatasetS3Uri(String var1);

        public Builder finalActiveLearningModelArn(String var1);
    }
}

