/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ClusterEventSummary;
import software.amazon.awssdk.services.sagemaker.model.ListClusterEventsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterEventsResponse;

public class ListClusterEventsIterable
implements SdkIterable<ListClusterEventsResponse> {
    private final SageMakerClient client;
    private final ListClusterEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListClusterEventsIterable(SageMakerClient client, ListClusterEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListClusterEventsResponseFetcher();
    }

    public Iterator<ListClusterEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClusterEventSummary> events() {
        Function<ListClusterEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListClusterEventsResponseFetcher
    implements SyncPageFetcher<ListClusterEventsResponse> {
        private ListClusterEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListClusterEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListClusterEventsResponse nextPage(ListClusterEventsResponse previousPage) {
            if (previousPage == null) {
                return ListClusterEventsIterable.this.client.listClusterEvents(ListClusterEventsIterable.this.firstRequest);
            }
            return ListClusterEventsIterable.this.client.listClusterEvents((ListClusterEventsRequest)((Object)ListClusterEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

