/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureParameter;
import software.amazon.awssdk.services.sagemaker.model.FeatureParameterAdditionsCopier;
import software.amazon.awssdk.services.sagemaker.model.FeatureParameterRemovalsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateFeatureMetadataRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateFeatureMetadataRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupName").getter(UpdateFeatureMetadataRequest.getter(UpdateFeatureMetadataRequest::featureGroupName)).setter(UpdateFeatureMetadataRequest.setter(Builder::featureGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupName").build()}).build();
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureName").getter(UpdateFeatureMetadataRequest.getter(UpdateFeatureMetadataRequest::featureName)).setter(UpdateFeatureMetadataRequest.setter(Builder::featureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateFeatureMetadataRequest.getter(UpdateFeatureMetadataRequest::description)).setter(UpdateFeatureMetadataRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<FeatureParameter>> PARAMETER_ADDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterAdditions").getter(UpdateFeatureMetadataRequest.getter(UpdateFeatureMetadataRequest::parameterAdditions)).setter(UpdateFeatureMetadataRequest.setter(Builder::parameterAdditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterAdditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeatureParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARAMETER_REMOVALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterRemovals").getter(UpdateFeatureMetadataRequest.getter(UpdateFeatureMetadataRequest::parameterRemovals)).setter(UpdateFeatureMetadataRequest.setter(Builder::parameterRemovals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterRemovals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD, FEATURE_NAME_FIELD, DESCRIPTION_FIELD, PARAMETER_ADDITIONS_FIELD, PARAMETER_REMOVALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateFeatureMetadataRequest.memberNameToFieldInitializer();
    private final String featureGroupName;
    private final String featureName;
    private final String description;
    private final List<FeatureParameter> parameterAdditions;
    private final List<String> parameterRemovals;

    private UpdateFeatureMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.featureName = builder.featureName;
        this.description = builder.description;
        this.parameterAdditions = builder.parameterAdditions;
        this.parameterRemovals = builder.parameterRemovals;
    }

    public final String featureGroupName() {
        return this.featureGroupName;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasParameterAdditions() {
        return this.parameterAdditions != null && !(this.parameterAdditions instanceof SdkAutoConstructList);
    }

    public final List<FeatureParameter> parameterAdditions() {
        return this.parameterAdditions;
    }

    public final boolean hasParameterRemovals() {
        return this.parameterRemovals != null && !(this.parameterRemovals instanceof SdkAutoConstructList);
    }

    public final List<String> parameterRemovals() {
        return this.parameterRemovals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterAdditions() ? this.parameterAdditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterRemovals() ? this.parameterRemovals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureMetadataRequest)) {
            return false;
        }
        UpdateFeatureMetadataRequest other = (UpdateFeatureMetadataRequest)((Object)obj);
        return Objects.equals(this.featureGroupName(), other.featureGroupName()) && Objects.equals(this.featureName(), other.featureName()) && Objects.equals(this.description(), other.description()) && this.hasParameterAdditions() == other.hasParameterAdditions() && Objects.equals(this.parameterAdditions(), other.parameterAdditions()) && this.hasParameterRemovals() == other.hasParameterRemovals() && Objects.equals(this.parameterRemovals(), other.parameterRemovals());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateFeatureMetadataRequest").add("FeatureGroupName", (Object)this.featureGroupName()).add("FeatureName", (Object)this.featureName()).add("Description", (Object)this.description()).add("ParameterAdditions", this.hasParameterAdditions() ? this.parameterAdditions() : null).add("ParameterRemovals", this.hasParameterRemovals() ? this.parameterRemovals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeatureGroupName": {
                return Optional.ofNullable(clazz.cast(this.featureGroupName()));
            }
            case "FeatureName": {
                return Optional.ofNullable(clazz.cast(this.featureName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ParameterAdditions": {
                return Optional.ofNullable(clazz.cast(this.parameterAdditions()));
            }
            case "ParameterRemovals": {
                return Optional.ofNullable(clazz.cast(this.parameterRemovals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeatureGroupName", FEATURE_GROUP_NAME_FIELD);
        map.put("FeatureName", FEATURE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ParameterAdditions", PARAMETER_ADDITIONS_FIELD);
        map.put("ParameterRemovals", PARAMETER_REMOVALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateFeatureMetadataRequest, T> g) {
        return obj -> g.apply((UpdateFeatureMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String featureGroupName;
        private String featureName;
        private String description;
        private List<FeatureParameter> parameterAdditions = DefaultSdkAutoConstructList.getInstance();
        private List<String> parameterRemovals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFeatureMetadataRequest model) {
            super(model);
            this.featureGroupName(model.featureGroupName);
            this.featureName(model.featureName);
            this.description(model.description);
            this.parameterAdditions(model.parameterAdditions);
            this.parameterRemovals(model.parameterRemovals);
        }

        public final String getFeatureGroupName() {
            return this.featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getFeatureName() {
            return this.featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<FeatureParameter.Builder> getParameterAdditions() {
            List<FeatureParameter.Builder> result = FeatureParameterAdditionsCopier.copyToBuilder(this.parameterAdditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterAdditions(Collection<FeatureParameter.BuilderImpl> parameterAdditions) {
            this.parameterAdditions = FeatureParameterAdditionsCopier.copyFromBuilder(parameterAdditions);
        }

        @Override
        public final Builder parameterAdditions(Collection<FeatureParameter> parameterAdditions) {
            this.parameterAdditions = FeatureParameterAdditionsCopier.copy(parameterAdditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterAdditions(FeatureParameter ... parameterAdditions) {
            this.parameterAdditions(Arrays.asList(parameterAdditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterAdditions(Consumer<FeatureParameter.Builder> ... parameterAdditions) {
            this.parameterAdditions(Stream.of(parameterAdditions).map(c -> (FeatureParameter)((FeatureParameter.Builder)FeatureParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getParameterRemovals() {
            if (this.parameterRemovals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parameterRemovals;
        }

        public final void setParameterRemovals(Collection<String> parameterRemovals) {
            this.parameterRemovals = FeatureParameterRemovalsCopier.copy(parameterRemovals);
        }

        @Override
        public final Builder parameterRemovals(Collection<String> parameterRemovals) {
            this.parameterRemovals = FeatureParameterRemovalsCopier.copy(parameterRemovals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterRemovals(String ... parameterRemovals) {
            this.parameterRemovals(Arrays.asList(parameterRemovals));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFeatureMetadataRequest build() {
            return new UpdateFeatureMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateFeatureMetadataRequest> {
        public Builder featureGroupName(String var1);

        public Builder featureName(String var1);

        public Builder description(String var1);

        public Builder parameterAdditions(Collection<FeatureParameter> var1);

        public Builder parameterAdditions(FeatureParameter ... var1);

        public Builder parameterAdditions(Consumer<FeatureParameter.Builder> ... var1);

        public Builder parameterRemovals(Collection<String> var1);

        public Builder parameterRemovals(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

